package org.simantics.document.server.state;

import java.util.function.Function;

import org.simantics.simulator.toolkit.StandardNodeManager;
import org.simantics.simulator.toolkit.StandardRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateRealm extends StandardRealm<StateNode, StateNodeManagerSupport> {

	private static final Logger LOGGER = LoggerFactory.getLogger(StateRealm.class);

	protected StateRealm(StateNodeManagerSupport engine, String id) {
		super(engine, id);
	}

	@Override
	public Logger getLogger() {
		return LOGGER;
	}

	@Override
	protected StandardNodeManager<StateNode, StateNodeManagerSupport> createManager() {
		return new StateNodeManager(this, new StateRootNode());
	}

	@Override
	public void asyncExec(Function fun) {
		try {
			syncExec(fun);
		} catch (InterruptedException e) {
			LOGGER.error("Execution interrupted.", e);
		}
	}

	@Override
	public void asyncExec(Runnable runnable) {
		try {
			syncExec(runnable);
		} catch (InterruptedException e) {
			LOGGER.error("Execution interrupted.", e);
		}
	}

}
