package org.simantics.document.server.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.server.DocumentServerUtils.AttributesRequest;
import org.simantics.document.server.JSONObject;
import org.simantics.utils.datastructures.Pair;

public class NodeRequest extends VariableRead<JSONObject> {

    public static final String ERRORS = "Errors";
    public static final String PROPERTY_VALUE_EXCEPTIONS = "_PropertyValueExceptions";
    
	public NodeRequest(Variable node) {
		super(node);
	}

	@SuppressWarnings("unchecked")
    @Override
	public JSONObject perform(ReadGraph graph) throws DatabaseException {

		long s = System.nanoTime();

		Pair<JSONObject, Collection<Variable>> attribs = graph.syncRequest(new AttributesRequest(variable));

	    JSONObject staticContent = attribs.first;
	    if(attribs.second.isEmpty()) {

	        if(DocumentRequest.PROFILE) {
	        	long dura = System.nanoTime()-s;
	            if(dura > DocumentRequest.PROFILE_THRESHOLD_NODEREQUEST * 1e3) {
	            	System.err.println("NodeRequest " + System.identityHashCode(this) + " in " + 1e-6*dura + "ms. " + variable.getURI(graph));
	            }
	        }

	    	return staticContent;
	    }

	    Map<String,Object> dynamicContent = graph.syncRequest(new NodeRequestDynamic(variable));
	    if(dynamicContent.isEmpty()) {
	        return staticContent;
	    }

        JSONObject result = staticContent.clone();
        result.add(dynamicContent);

        if(dynamicContent.containsKey(ERRORS) || staticContent.getJSONField(ERRORS) != null) {
            ArrayList<String> errorList = new ArrayList<>();

            if(dynamicContent.containsKey(ERRORS))
                errorList.addAll((List<String>)dynamicContent.get(ERRORS));

            if(staticContent.getJSONField(ERRORS) != null)
                errorList.addAll((List<String>)staticContent.getJSONField(ERRORS));

            result.addJSONField(ERRORS, errorList);
        }

        if(DocumentRequest.PROFILE) {
            long dura = System.nanoTime()-s;
            if(dura > DocumentRequest.PROFILE_THRESHOLD_NODEREQUEST * 1e3) {
                System.err.println("NodeRequest " + System.identityHashCode(this) + " in " + 1e-6*dura + "ms. " + variable.getURI(graph));
            }
        }
        
        return result;

    }

}