package org.simantics.document.server.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.document.server.handler.AbstractEventHandler;
import org.simantics.structural.stubs.StructuralResource2;

public class HandleEventRequest implements Read<AbstractEventHandler> {

    final String id;

    public HandleEventRequest(String id) {
        this.id = id;
    }

    @Override
    public AbstractEventHandler perform(ReadGraph graph) throws DatabaseException {

        StructuralResource2.getInstance(graph);

        Variable variable = Variables.getPossibleVariable(graph, id);
        if(variable == null) return null;

//        System.err.println("EVENT " + variable.getURI(graph));
        Object handler = variable.getValue(graph);
        if(handler instanceof AbstractEventHandler)
            return (AbstractEventHandler) handler;
        else
            throw new DatabaseException("Handler for " + id + " is not instance of AbstractEventHandler (it is instance of " + (handler != null ? handler.getClass() : null) + ")");
    }

}