package org.simantics.document.server.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.server.JSONObject;

public class DocumentRequest extends VariableRead<List<JSONObject>> {
	
	public static boolean PROFILE = false;
	// Thresholds in microseconds
	public static int PROFILE_THRESHOLD_NODEREQUEST = 2000;
	public static int PROFILE_THRESHOLD_VALUEREQUEST = 500;

    public DocumentRequest(Variable var) {
        super(var);
	}

	@Override
	public List<JSONObject> perform(ReadGraph graph) throws DatabaseException {
		
		long s = System.nanoTime();
		
        Set<Variable> nodes = graph.syncRequest(new NodesRequest(variable), TransientCacheAsyncListener.<Set<Variable>>instance());
        HashSet<JSONObject> rs = new HashSet<JSONObject>(); // result
        if(nodes.isEmpty()) {
            return Collections.emptyList();
        }
        
        
        /*TreeMap<String, Variable> nodeMap = new TreeMap<String, Variable>();
        
        for (Variable node : nodes) {
        	nodeMap.put(node.getURI(graph), node);
        }
        System.out.println("*************************************************************************");
        for (Variable node : nodeMap.values()) {
        	System.out.println("               " + node.getURI(graph));
        }*/
        
        for(Variable node : nodes) {
            rs.add(graph.syncRequest(new NodeRequest(node), TransientCacheAsyncListener.<JSONObject>instance()));
        }

		ArrayList<JSONObject> result = new ArrayList<JSONObject>(rs);
		Collections.sort(result, new Comparator<JSONObject>() {

			@Override
			public int compare(JSONObject o1, JSONObject o2) {
				return o1.id.compareTo(o2.id);
			}
			
		});
        
        if(PROFILE) {
        	long dura = System.nanoTime()-s;
        	System.err.println("DocumentRequest " + System.identityHashCode(this) + " in " + 1e-6*dura + "ms. " + variable.getURI(graph));
        }

		return result;

	}
}