package org.simantics.document.server.handler;

import org.simantics.Simantics;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandResult;
import org.simantics.document.server.serverResponse.Error;
import org.simantics.document.server.serverResponse.IDelayedResponse;

public abstract class WriteEventHandler extends AbstractEventHandler {

    protected abstract CommandResult handle(WriteGraph graph, CommandContext parameters) throws DatabaseException;

    public CommandResult handle(final CommandContext parameters) {
        try {
        	CommandResult response = Simantics.getSession().syncRequest(new WriteResultRequest<CommandResult>() {
                @Override
                public CommandResult perform(WriteGraph graph) throws DatabaseException {
                    graph.markUndoPoint();
                    return handle(graph, parameters);
                }
            });

            if(response instanceof IDelayedResponse && !(((IDelayedResponse)response).hasRun())) {
                try {
                    synchronized(response) {
                        response.wait(200000);
                    }
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            
            return response;
        } catch (DatabaseException e) {
            e.printStackTrace();
            return new Error(e.getMessage()); // Return some error
        }
    }


}
