package org.simantics.document.server.bean;

import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.ICommand;

public class Command implements ICommand {
    
    public String targetId;
    public String trigger;
    public String command;
    public CommandContext constants;

    public Command() {}
    
    public Command(String targetId, String trigger, String command, CommandContext constants) {
        this.targetId = targetId;
        this.trigger = trigger;
        this.command = command;     
        this.constants = constants;
    }

    public String getTrigger() {
        return trigger;
    }

    public String getTargetId() {
        return targetId;
    }

    public String getCommand() {
        return command;
    }

    @Override
    public CommandContext getConstants() {
        return constants;
    }

    @Override
    public String toString() {
    	StringBuilder sb = new StringBuilder();
    	sb.append("\n");
    	sb.append(targetId);
    	sb.append("\n");
    	sb.append(trigger);
    	sb.append("\n");
    	sb.append(command);
    	sb.append("\n");
    	sb.append(constants);
    	sb.append("\n");
    	return sb.toString();
    }
    
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((command == null) ? 0 : command.hashCode());
		result = prime * result
				+ ((constants == null) ? 0 : constants.hashCode());
		result = prime * result
				+ ((targetId == null) ? 0 : targetId.hashCode());
		result = prime * result + ((trigger == null) ? 0 : trigger.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Command other = (Command) obj;
		if (command == null) {
			if (other.command != null)
				return false;
		} else if (!command.equals(other.command))
			return false;
		if (constants == null) {
			if (other.constants != null)
				return false;
		} else if (!constants.equals(other.constants))
			return false;
		if (targetId == null) {
			if (other.targetId != null)
				return false;
		} else if (!targetId.equals(other.targetId))
			return false;
		if (trigger == null) {
			if (other.trigger != null)
				return false;
		} else if (!trigger.equals(other.trigger))
			return false;
		return true;
	}
    
    
}
