/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.wizard;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.simantics.db.Resource;
import org.simantics.document.linking.wizard.ReportCustomizationPage;
import org.simantics.document.linking.wizard.ReportGeneratePage;
import org.simantics.document.linking.wizard.ReportSelectionPage;
import org.simantics.utils.ui.AdaptionUtils;

public class ReportWizard
extends Wizard
implements IExportWizard {
    Resource selectedResource;
    ReportSelectionPage reportSelectionPage;
    ReportCustomizationPage reportCustomizationPage;
    ReportGeneratePage reportGeneratePage;
    LocalResourceManager manager = new LocalResourceManager(JFaceResources.getResources());

    public ReportWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.reportSelectionPage = new ReportSelectionPage("Select report parameters");
        this.reportCustomizationPage = new ReportCustomizationPage("Customize report");
        this.reportGeneratePage = new ReportGeneratePage("Run Report");
        this.addPage((IWizardPage)this.reportSelectionPage);
        this.addPage((IWizardPage)this.reportCustomizationPage);
        this.addPage((IWizardPage)this.reportGeneratePage);
        if (this.selectedResource != null) {
            this.reportSelectionPage.setInput(this.selectedResource);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.reportSelectionPage) {
            this.reportCustomizationPage.setReportWriter(this.reportSelectionPage.getSelectedWriter());
            this.reportCustomizationPage.setModel(this.reportSelectionPage.getSelectedModel());
            this.reportGeneratePage.setFilename(this.reportSelectionPage.getFilename());
            this.reportGeneratePage.setModel(this.reportSelectionPage.getSelectedModel());
            this.reportGeneratePage.setReportWriter(this.reportSelectionPage.getSelectedWriter());
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        return this.reportGeneratePage.isGenerated();
    }

    public boolean canFinish() {
        if (!this.reportGeneratePage.isGenerated()) {
            return false;
        }
        return super.canFinish();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selectedResource = (Resource)AdaptionUtils.adaptToSingle((Object)selection, Resource.class);
        if (this.reportSelectionPage != null) {
            this.reportSelectionPage.setInput(this.selectedResource);
        }
    }

    public void dispose() {
        this.manager.dispose();
        super.dispose();
    }
}

