/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.wizard;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.ListDialog;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.PossibleObjectWithName;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.document.linking.report.evaluator.DBUtil;
import org.simantics.document.linking.report.templates.CustomizableContentProvider;
import org.simantics.document.linking.report.templates.ReportWriter;
import org.simantics.document.linking.report.templates.custom.CustomizableContent;
import org.simantics.document.linking.report.templates.custom.EvaluatorCustomizableContent;
import org.simantics.document.linking.report.templates.custom.SCLCustomizableContent;
import org.simantics.document.linking.wizard.EvaluatorConfigurationWidget;
import org.simantics.document.linking.wizard.ReportWizard;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.validators.NotNullValidator;

public class ReportCustomizationPage
extends WizardPage {
    ReportWriter<?> reportWriter;
    Resource model;
    private Map<String, Composite> widgets = new LinkedHashMap<String, Composite>();
    private TabFolder tabFolder;
    private Map<String, TabItem> tabs = new LinkedHashMap<String, TabItem>();
    private Button loadButton;
    private Button saveButton;
    private Button resetButton;
    private Resource library;

    protected ReportCustomizationPage(String pageName) {
        super(pageName, pageName, null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)composite);
        this.tabFolder = new TabFolder(composite, 0);
        this.tabFolder.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.tabFolder);
        Composite buttonComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 1024).grab(true, false).applyTo((Control)buttonComposite);
        buttonComposite.setLayout((Layout)new GridLayout(3, true));
        this.loadButton = new Button(buttonComposite, 8);
        this.saveButton = new Button(buttonComposite, 8);
        this.resetButton = new Button(buttonComposite, 8);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.loadButton);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.saveButton);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.resetButton);
        this.loadButton.setText("Load");
        this.saveButton.setText("Save");
        this.resetButton.setText("Defaults");
        this.loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportCustomizationPage.this.load();
            }
        });
        this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportCustomizationPage.this.save();
            }
        });
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportCustomizationPage.this.reset();
            }
        });
        this.updateContent();
    }

    public void setReportWriter(ReportWriter<?> reportWriter) {
        this.reportWriter = reportWriter;
        this.updateContentProviders();
        this.updateContent();
    }

    public void setModel(final Resource model) {
        this.model = model;
        try {
            this.library = (Resource)Simantics.getSession().syncRequest((Read)new Read<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    Resource lib = (Resource)graph.syncRequest((Read)new PossibleObjectWithName(model, l0.ConsistsOf, "Library"));
                    if (lib != null) {
                        return lib;
                    }
                    return model;
                }
            });
        }
        catch (DatabaseException databaseException) {
            this.library = model;
        }
    }

    private void updateContentProviders() {
        if (this.reportWriter instanceof CustomizableContentProvider) {
            LocalResourceManager manager = ((ReportWizard)this.getWizard()).manager;
            CustomizableContentProvider provider = (CustomizableContentProvider)((Object)this.reportWriter);
            Collection<String> ids = provider.getContentIds();
            for (String id : this.tabs.keySet()) {
                if (ids.contains(id)) continue;
                this.tabs.remove(id).dispose();
                Composite c = this.widgets.get(id);
                if (c == null || c.isDisposed()) continue;
                c.dispose();
            }
            for (String id : ids) {
                CustomizableContent content = provider.getContent(id);
                if (content instanceof EvaluatorCustomizableContent) {
                    TabItem item = this.tabs.get(id);
                    if (item == null) {
                        item = new TabItem(this.tabFolder, 0);
                        this.tabs.put(id, item);
                    }
                    item.setText(content.getCustomizationDescription());
                    EvaluatorConfigurationWidget w = new EvaluatorConfigurationWidget((Composite)this.tabFolder, manager, 0);
                    w.setInput((EvaluatorCustomizableContent)content);
                    GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)w);
                    Composite c = this.widgets.put(id, w);
                    if (c != null) {
                        c.dispose();
                    }
                    item.setControl((Control)w);
                    continue;
                }
                boolean cfr_ignored_0 = content instanceof SCLCustomizableContent;
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.updateContent();
    }

    private void updateContent() {
        for (Composite c : this.widgets.values()) {
            if (!(c instanceof EvaluatorConfigurationWidget)) continue;
            ((EvaluatorConfigurationWidget)c).updateContent();
        }
        ((Composite)this.getControl()).layout(true);
    }

    private void load() {
        try {
            List<NamedResource> templates = DBUtil.getTemplates(this.library);
            ListDialog dialog = new ListDialog(this.getShell());
            dialog.setContentProvider(new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    List list = (List)inputElement;
                    return list.toArray();
                }
            });
            dialog.setLabelProvider((ILabelProvider)new LabelProvider());
            dialog.setInput(templates);
            if (dialog.open() != 0) {
                return;
            }
            Object[] result = dialog.getResult();
            if (result == null || result.length != 1) {
                return;
            }
            final NamedResource selectedTemplate = (NamedResource)result[0];
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    DBUtil.load(graph, selectedTemplate.getResource(), (CustomizableContentProvider)((Object)ReportCustomizationPage.this.reportWriter));
                }
            });
            this.updateContentProviders();
            this.updateContent();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    private void save() {
        try {
            InputDialog dialog = new InputDialog(this.getShell(), "Save report customization", "Give template name", "Name", (IInputValidator)new NotNullValidator("Name cannot be empty"));
            if (dialog.open() != 0) {
                return;
            }
            String name = dialog.getValue();
            if (name == null || name.length() == 0) {
                return;
            }
            DBUtil.save(this.library, name, (CustomizableContentProvider)((Object)this.reportWriter));
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    private void reset() {
        if (this.reportWriter instanceof CustomizableContentProvider) {
            CustomizableContentProvider ccp = (CustomizableContentProvider)((Object)this.reportWriter);
            for (String id : ccp.getContentIds()) {
                ccp.setDefaultContent(id);
            }
            this.updateContentProviders();
            this.updateContent();
        }
    }
}

