/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.utils.SourceLinkUtil;
import org.simantics.scl.runtime.function.FunctionImpl5;
import org.simantics.workbench.search.NamedResource;
import org.simantics.workbench.search.SearchQuery;
import org.simantics.workbench.search.SearchResult;
import org.simantics.workbench.search.SearchResultColumn;
import org.simantics.workbench.search.SearchResultRow;
import org.simantics.workbench.search.StringUtil;

public class SearchFunction
extends FunctionImpl5<IProgressMonitor, ReadGraph, Resource, SearchQuery, Integer, SearchResult> {
    public static List<SearchResultColumn> columns = new ArrayList<SearchResultColumn>();

    static {
        columns.add(new SearchResultColumn("Name"));
        columns.add(new SearchResultColumn("Comment"));
        columns.add(new SearchResultColumn("Part Of"));
    }

    public SearchResult apply(IProgressMonitor monitor, ReadGraph graph, Resource model, SearchQuery query, Integer maxResults) {
        try {
            DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
            Instances instancesQuery = (Instances)graph.adapt(sl.Source, Instances.class);
            Collection found = instancesQuery.find(graph, model);
            return SearchFunction.generateSearchResults(graph, found, query);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    public static final SearchResult generateSearchResults(ReadGraph graph, Collection<Resource> results, SearchQuery query) throws DatabaseException {
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        SearchResult result = new SearchResult(columns);
        HashSet<Resource> processed = new HashSet<Resource>();
        NameComparator c = new NameComparator(query.getQuery(new String[]{"NameSearch"}));
        for (Resource source : results) {
            Resource reference;
            if (!processed.add(source) || !SourceLinkUtil.isValidReference(graph, reference = SourceLinkUtil.getReferredDocument(graph, source))) continue;
            Resource parent = graph.getSingleObject(source, sl.hasSource_Inverse);
            String name = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)reference);
            if (name.length() == 0) {
                name = NameUtils.getSafeName((ReadGraph)graph, (Resource)reference);
            }
            if (!c.compare(name)) continue;
            String parentName = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)parent);
            if (parentName.length() == 0) {
                parentName = NameUtils.getSafeName((ReadGraph)graph, (Resource)parent);
            }
            if (graph.isInstanceOf(source, sl.FunctionalSource)) {
                Resource relation = graph.getSingleObject(source, sl.consernsRelation);
                String relationName = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)relation);
                if (relationName.length() == 0) {
                    relationName = NameUtils.getSafeName((ReadGraph)graph, (Resource)relation);
                }
                parentName = String.valueOf(parentName) + "#" + relationName;
            }
            DocumentLinkRow rst = new DocumentLinkRow();
            rst.resource = NamedResource.of((ReadGraph)graph, (Resource)reference, (String)name);
            rst.parent = NamedResource.of((ReadGraph)graph, (Resource)parent, (String)parentName);
            rst.comment = (String)graph.getPossibleRelatedValue(source, sl.hasSourceComment, (Binding)Bindings.STRING);
            result.addRow((SearchResultRow)rst);
        }
        return result;
    }

    private static class DocumentLinkRow
    implements SearchResultRow {
        public NamedResource resource;
        public NamedResource parent;
        public String comment;

        private DocumentLinkRow() {
        }

        public String getContent(int column) {
            switch (column) {
                case 0: {
                    return "<a class=\"small\" href=\"resource:" + this.resource.getResource() + "\"" + (this.resource.getUri() == null ? "" : " title=\"" + this.resource.getUri() + "\">") + StringUtil.escape((String)this.resource.getName()) + "</a>";
                }
                case 1: {
                    if (this.comment != null) {
                        return this.comment;
                    }
                    return "";
                }
                case 2: {
                    if (this.parent != null) {
                        return "<a class=\"small\" href=\"resource:" + this.parent.getResource() + "\"" + (this.parent.getUri() == null ? "" : " title=\"" + this.parent.getUri() + "\">") + StringUtil.escape((String)this.parent.getName()) + "</a>";
                    }
                    return "";
                }
            }
            return "";
        }
    }

    public static class NameComparator {
        private String name;
        int type = 0;

        public NameComparator(String query) {
            String[] parts;
            String[] stringArray = parts = query.split(" OR ");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.startsWith("Name:")) {
                    this.name = s.substring(5);
                }
                ++n2;
            }
            if (this.name == null) {
                return;
            }
            this.name = this.name.trim();
            boolean freeStart = false;
            boolean freeEnd = false;
            if (this.name.endsWith("*")) {
                this.name = this.name.substring(0, this.name.length() - 1);
                freeEnd = true;
            }
            if (this.name.startsWith("*")) {
                this.name = this.name.substring(1, this.name.length());
                freeStart = true;
            }
            if (freeStart && freeEnd) {
                this.type = 1;
            } else if (freeStart) {
                this.type = 2;
            } else if (freeEnd) {
                this.type = 3;
            }
            this.name = this.name.toLowerCase();
        }

        public boolean compare(String s) {
            switch (this.type) {
                case 0: {
                    return s.toLowerCase().equals(this.name);
                }
                case 1: {
                    return s.toLowerCase().contains(this.name);
                }
                case 2: {
                    return s.toLowerCase().endsWith(this.name);
                }
                case 3: {
                    return s.toLowerCase().startsWith(this.name);
                }
            }
            return false;
        }
    }
}

