package org.simantics.document.linking.wizard;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.simantics.db.Resource;
import org.simantics.utils.ui.AdaptionUtils;

/**
 * Wizard for exporting reports.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class ReportWizard extends Wizard implements IExportWizard{
	
	Resource selectedResource;
	ReportSelectionPage reportSelectionPage;
	ReportCustomizationPage reportCustomizationPage;
	ReportGeneratePage reportGeneratePage;
	
	LocalResourceManager manager = new LocalResourceManager(JFaceResources.getResources());
	
	public ReportWizard() {
		setNeedsProgressMonitor(true);
	}
	
	@Override
	public void addPages() {
		reportSelectionPage = new ReportSelectionPage("Select report parameters");
		reportCustomizationPage = new ReportCustomizationPage("Customize report");
		reportGeneratePage = new ReportGeneratePage("Run Report");
		addPage(reportSelectionPage);
		addPage(reportCustomizationPage);
		addPage(reportGeneratePage);
		if (selectedResource != null)
			reportSelectionPage.setInput(selectedResource);
	}
	
	@Override
	public IWizardPage getNextPage(IWizardPage page) {
		if (page == reportSelectionPage) {
			reportCustomizationPage.setReportWriter(reportSelectionPage.getSelectedWriter());
			reportCustomizationPage.setModel(reportSelectionPage.getSelectedModel());
			reportGeneratePage.setFilename(reportSelectionPage.getFilename());
			reportGeneratePage.setModel(reportSelectionPage.getSelectedModel());
			reportGeneratePage.setReportWriter(reportSelectionPage.getSelectedWriter());
		} 
		return super.getNextPage(page);
	}

	@Override
	public boolean performFinish() {
		return reportGeneratePage.isGenerated();
	}
	
	@Override
	public boolean canFinish() {
		if (!reportGeneratePage.isGenerated())
			return false;
		return super.canFinish();
	}

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		selectedResource = AdaptionUtils.adaptToSingle(selection, Resource.class);
		if (reportSelectionPage != null)
			reportSelectionPage.setInput(selectedResource);
	}
	
	@Override
	public void dispose() {
		manager.dispose();
		super.dispose();
	}

}
