package org.simantics.document.linking.report.templates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.document.DocumentResource;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.utils.SourceLinkUtil;

/**
 * Writes report of referred documents.
 * 
 * Model information
    □ Document folder 1
        • Document 1-1
        • Document 1-2 rev1
        • Document 1-2 rev2
        • Document 1-2 rev3
        • Document 1-3
    □ Document folder 2
        • Document folder 3
            o Document 3-1
            o Document 3-2
        • Document folder 4
            o Document 4-1
            o Document 4-2
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class ReferredDocumentWriter extends ModelDocumentWriter{

	@Override
	public String getName() {
		return "Referred Documents";
	}
	

	@Override
	public List<List<Resource>> getReportItems(ReadGraph graph)	throws DatabaseException {
		DocumentResource doc = DocumentResource.getInstance(graph);
		DocumentLink sl = DocumentLink.getInstance(graph);
		Instances instancesQuery = graph.adapt(sl.Source, Instances.class);
        Collection<Resource> found = instancesQuery.find(graph, model);
        Set<Resource> referred = new HashSet<Resource>();
        for (Resource source : found) {
        	Resource ref = SourceLinkUtil.getReferredDocument(graph, source);
        	if (ref != null)
        		referred.add(ref);
        }
        found = null;
        List<List<Resource>> result = new ArrayList<List<Resource>>();
        for (Resource ref : referred) {
        	if (!graph.isInstanceOf(ref, doc.Document))
        		continue;
        	result.add(SourceLinkUtil.getPath(graph,model,ref));
        }
        referred = null;
        Collections.sort(result, new PathComparator(graph));
        return result;
	}

}
