/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.ui.internal;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;

/**
 * @author Antti Villberg
 */
public class TGEditorAdapter extends AbstractResourceEditorAdapter {

	public static final String EDITOR_ID = "org.simantics.modeling.ui.pgraphEditor";
	
    public TGEditorAdapter() {
        super("Ontology Viewer", SimanticsUI.getImageDescriptor("icons/etool16/bug.png"));
    }

    @Override
    public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
    	Resource indexRoot = g.syncRequest(new PossibleIndexRoot(r));
    	if(indexRoot == null) return false;
    	Layer0 L0 = Layer0.getInstance(g);
    	return g.isInstanceOf(indexRoot, L0.Ontology);
    }

    @Override
    public void openEditor(Resource r) throws Exception {
        openEditorWithId(EDITOR_ID, new ResourceEditorInput(EDITOR_ID,r));
    }
    
}
