/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     THTH ry - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.browser.internal.rewriters;

import java.util.ArrayList;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.browser.content.ResourceBrowserContent;
import org.simantics.debug.browser.content.ResourceBrowserRewriter;
import org.simantics.debug.browser.sections.RawStatementsSection;
import org.simantics.debug.browser.sections.TypeHierarchySection;
import org.simantics.debug.browser.sections.TypeHierarchySection.Node;
import org.simantics.debug.browser.utils.ResourceInfo;
import org.simantics.layer0.Layer0;

public enum TypeHierarchyCreator implements ResourceBrowserRewriter {
    INSTANCE;

    @Override
    public void rewrite(ReadGraph graph, ResourceBrowserContent content)
            throws DatabaseException {
        content.putSection(TypeHierarchySection.class,
                new TypeHierarchySection(
                        new Node(null, null, getSuper(graph, content.resource))
                        ));
        
        // Remove raw statements that this section already shows
        Layer0 L0 = Layer0.getInstance(graph);
        RawStatementsSection rawStatementsSection = content.getSection(RawStatementsSection.class);
        rawStatementsSection.statementsByPredicates.remove(L0.InstanceOf);
        rawStatementsSection.statementsByPredicates.remove(L0.SubrelationOf);
        rawStatementsSection.statementsByPredicates.remove(L0.Inherits);
    }
    
    public Node[] getSuper(ReadGraph graph, Resource resource) throws DatabaseException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Layer0 L0 = Layer0.getInstance(graph);
        for(Resource s : graph.getObjects(resource, L0.InstanceOf))
            nodes.add(new Node(":", new ResourceInfo(graph, s), getSuper(graph, s)));
        for(Resource s : graph.getObjects(resource, L0.Inherits)) {
            if(s.equals(L0.Entity))
                continue;
            nodes.add(new Node("&lt;T", new ResourceInfo(graph, s), getSuper(graph, s)));
        }
        for(Resource s : graph.getObjects(resource, L0.SubrelationOf)) {
            if(s.equals(L0.IsWeaklyRelatedTo))
                continue;
            nodes.add(new Node("&lt;R", new ResourceInfo(graph, s), getSuper(graph, s)));
        }
        return nodes.toArray(new Node[nodes.size()]);
    }

    @Override
    public double getPriority() {
        return 1;
    }
}
