/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     THTH ry - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.browser.internal;

import java.net.URL;

import org.simantics.scl.runtime.reporting.SCLReporting;

/**
 * @author Tuukka Lehtonen / Semantum Oy
 */
public class SCL {

    public static void startDebugServer() throws Exception {
        Activator activator = Activator.getDefault();
        DebugBrowserServer server = activator.getDebugServer();
        if (server == null) {
            server = activator.startDebugServer();
            SCLReporting.print("Started debug server at " + server.getURL());
        } else {
            SCLReporting.print("Debug server is already running at " + server.getURL());
        }
    }

    public static void stopDebugServer() throws Exception {
        Activator activator = Activator.getDefault();
        DebugBrowserServer server = activator.getDebugServer();
        if (server != null) {
            URL url = server.getURL();
            activator.stopDebugServer();
            SCLReporting.print("Stopped debug server that was running at " + url);
        } else {
            SCLReporting.print("Debug server is not running.");
        }
    }

}
