package org.simantics.db.testing.common;

import java.io.File;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.DefaultPasteImportAdvisor;
import org.simantics.db.layer0.request.ActivateModel;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.TransferableGraphFileReader;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

public class TestingUtils {

	public static Resource importModel(final Resource toLocation, File fromFile, String withName) throws Exception {
		
        TransferableGraph1 tg = TransferableGraphFileReader.read(fromFile);

        final DefaultPasteImportAdvisor advisor = new DefaultPasteImportAdvisor(toLocation) {
            @Override
            public void analyzeType(ReadGraph graph, Root root) throws DatabaseException {
                Resource typeResource = graph.getResource(root.type);
                if (graph.isInheritedFrom(typeResource, SimulationResource.getInstance(graph).Model)) {
                    library = toLocation;
                }
            }
        };
        
        TransferableGraphs.importGraph1(Simantics.getSession(), tg, advisor, null);
        
        Simantics.getSession().syncRequest(new WriteRequest() {
            @Override
            public void perform(WriteGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance(graph);
                String name = graph.getPossibleRelatedValue(advisor.getRoot(), L0.HasName);
                if (name != null)
                    graph.claimLiteral(advisor.getRoot(), L0.HasLabel, name);
                graph.syncRequest(new ActivateModel(toLocation, advisor.getRoot()));
                
            }
        });
        
        return advisor.getRoot();
		
	}
	
	public static Resource getResource(final Resource base, final String suffix) throws DatabaseException {
	    
	    return Simantics.getSession().syncRequest(new Read<Resource>() {

            @Override
            public Resource perform(ReadGraph graph) throws DatabaseException {
                String baseURI = graph.getURI(base);
                return graph.getResource(baseURI + suffix);
            }
	        
	    });
	    
	}
	
	public static double readConfiguration(Resource model, String rvi) throws DatabaseException {
	    
	    class ReadConfiguration extends BinaryRead<Resource, String, Double> {
	        
	        public ReadConfiguration(Resource model, String rvi) {
	            super(model, rvi);
	        }

	        @Override
	        public Double perform(ReadGraph graph) throws DatabaseException {
	            Variable state = Variables.getVariable(graph, graph.getURI(parameter) + parameter2);
	            float result = state.getValue(graph); 
	            return (double)result;
	        }
	        
	    }
	    
	    return Simantics.getSession().syncRequest(new ReadConfiguration(model, rvi));
	    
	}
	
    public static double readState(Resource run, String rvi) throws DatabaseException {
        
        class ReadState extends BinaryRead<Resource, String, Double> {
            
            public ReadState(Resource run, String rvi) {
                super(run, rvi);
            }

            @Override
            public Double perform(ReadGraph graph) throws DatabaseException {
                Variable state = Variables.getVariable(graph, graph.getURI(parameter) + parameter2);
                float result = state.getValue(graph); 
                return (double)result;
            }
            
        }
        
        return Simantics.getSession().syncRequest(new ReadState(run, rvi));
        
    }

	public static boolean lineEquals(String s1, String s2) {
		if(s1 == null) {
			if(s2 == null) return true;
			else return false;
		} else {
			if(s2 == null) return false;
			else return s1.equals(s2);
		}
	}
	
	public static String compare(String s1, String s2) {
		if(s1.equals(s2)) return null;
		String[] lines1 = s1.split("\n");
		String[] lines2 = s2.split("\n");
		for(int i=0;i<Math.max(lines1.length, lines2.length); i++) {
			String t1 = (i < lines1.length) ? lines1[i] : null;
			String t2 = (i < lines2.length) ? lines2[i] : null;
			if(!lineEquals(t1, t2)) return "Difference at line " + (i+1) + ": '" + t1 + "' vs. '" + t2 + "'";
		}
		return null;
	}
	
}
