package org.simantics.db.testing.cases;
/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/


import org.junit.After;
import org.junit.Before;
import org.simantics.SimanticsPlatform;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.testing.common.DatabaseState;
import org.simantics.db.testing.common.TestBase;
import org.simantics.db.testing.common.TestSettings;
import org.simantics.db.testing.common.Tests;

public class FreshDatabaseTest extends TestBase {

    public void configure(TestSettings settings) {

    }

    @Before
    public void setUp() throws Exception {

        TestBase.printStart(this);
        TestSettings testSettings = TestSettings.getInstanceUnsafe();
        configure(testSettings);
//        state = AcornTests.newSimanticsWorkspace(testSettings, null);
        state = Tests.newSimanticsWorkspace(testSettings, null);

        super.setUp();

    }

    @After
    public void tearDown() throws Exception {
    	Tests.shutdown(state);
    	super.tearDown();
    }

    public Resource getProjectResource() {
        return SimanticsPlatform.INSTANCE.projectResource;
    }

    protected Session getSession() {
        return state.getSession();
    }

    public DatabaseState getState() {
        return state;
    }

    public void reconnect() throws Exception {
    	setPrintStart(false);
        tearDown();
        setUp();
    	setPrintStart(true);
    }
}
