/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.server.protocol;
import static org.simantics.db.server.protocol.MessageNumber.AAARequest;
import static org.simantics.db.server.protocol.MessageNumber.AAAResponse;
import static org.simantics.db.server.protocol.MessageNumber.AcceptCommitRequest;
import static org.simantics.db.server.protocol.MessageNumber.AskToRelinquishRequest;
import static org.simantics.db.server.protocol.MessageNumber.AskToRelinquishResponse;
import static org.simantics.db.server.protocol.MessageNumber.AskTransactionRequest;
import static org.simantics.db.server.protocol.MessageNumber.AskTransactionResponse;
import static org.simantics.db.server.protocol.MessageNumber.CancelCommitRequest;
import static org.simantics.db.server.protocol.MessageNumber.CancelCommitResponse;
import static org.simantics.db.server.protocol.MessageNumber.ChangeSetUpdateRequest;
import static org.simantics.db.server.protocol.MessageNumber.CloseClientSessionRequest;
import static org.simantics.db.server.protocol.MessageNumber.CloseClientSessionResponse;
import static org.simantics.db.server.protocol.MessageNumber.EchoRequest;
import static org.simantics.db.server.protocol.MessageNumber.EchoResponse;
import static org.simantics.db.server.protocol.MessageNumber.EndTransactionRequest;
import static org.simantics.db.server.protocol.MessageNumber.EndTransactionResponse;
import static org.simantics.db.server.protocol.MessageNumber.ExceptionRequest;
import static org.simantics.db.server.protocol.MessageNumber.ExceptionResponse;
import static org.simantics.db.server.protocol.MessageNumber.ExecuteRequest;
import static org.simantics.db.server.protocol.MessageNumber.ExecuteResponse;
import static org.simantics.db.server.protocol.MessageNumber.GetChangeSetContextRequest;
import static org.simantics.db.server.protocol.MessageNumber.GetChangeSetContextResponse;
import static org.simantics.db.server.protocol.MessageNumber.GetChangeSetDataRequest;
import static org.simantics.db.server.protocol.MessageNumber.GetChangeSetDataResponse;
import static org.simantics.db.server.protocol.MessageNumber.GetChangeSetsRequest;
import static org.simantics.db.server.protocol.MessageNumber.GetChangeSetsResponse;
import static org.simantics.db.server.protocol.MessageNumber.GetClusterChangesRequest;
import static org.simantics.db.server.protocol.MessageNumber.GetClusterChangesResponse;
import static org.simantics.db.server.protocol.MessageNumber.GetClusterNewRequest;
import static org.simantics.db.server.protocol.MessageNumber.GetClusterNewResponse;
import static org.simantics.db.server.protocol.MessageNumber.GetRefresh2Request;
import static org.simantics.db.server.protocol.MessageNumber.GetRefresh2Response;
import static org.simantics.db.server.protocol.MessageNumber.GetRefreshRequest;
import static org.simantics.db.server.protocol.MessageNumber.GetRefreshResponse;
import static org.simantics.db.server.protocol.MessageNumber.GetResourceSegmentRequest;
import static org.simantics.db.server.protocol.MessageNumber.GetResourceSegmentResponse;
import static org.simantics.db.server.protocol.MessageNumber.GetServerInfo2Request;
import static org.simantics.db.server.protocol.MessageNumber.GetServerInfo2Response;
import static org.simantics.db.server.protocol.MessageNumber.GetServerInfoRequest;
import static org.simantics.db.server.protocol.MessageNumber.GetServerInfoResponse;
import static org.simantics.db.server.protocol.MessageNumber.ListClustersRequest;
import static org.simantics.db.server.protocol.MessageNumber.ListClustersResponse;
import static org.simantics.db.server.protocol.MessageNumber.NullRequest;
import static org.simantics.db.server.protocol.MessageNumber.NullResponse;
import static org.simantics.db.server.protocol.MessageNumber.OpenClientSessionRequest;
import static org.simantics.db.server.protocol.MessageNumber.OpenClientSessionResponse;
import static org.simantics.db.server.protocol.MessageNumber.ReconnectRequest;
import static org.simantics.db.server.protocol.MessageNumber.ReconnectResponse;
import static org.simantics.db.server.protocol.MessageNumber.RefreshRequest;
import static org.simantics.db.server.protocol.MessageNumber.RefreshResponse;
import static org.simantics.db.server.protocol.MessageNumber.ReserveIdsRequest;
import static org.simantics.db.server.protocol.MessageNumber.ReserveIdsResponse;
import static org.simantics.db.server.protocol.MessageNumber.ShoutRequest;
import static org.simantics.db.server.protocol.MessageNumber.SinkRequest;
import static org.simantics.db.server.protocol.MessageNumber.UndoRequest;
import static org.simantics.db.server.protocol.MessageNumber.UndoResponse;
import static org.simantics.db.server.protocol.MessageNumber.UpdateClusterRequest;
public final class MessageText {
    public static String get(int a) {
        switch (a) {
            default: return "Illegal type=" + a + ".";
            case AAARequest: return "AAARequest";
            case AAAResponse: return "AAAResponse";
            case AcceptCommitRequest: return "AcceptCommitRequest";
            case AskToRelinquishRequest: return "AskToRelinquishRequest";
            case AskToRelinquishResponse: return "AskToRelinquishResponse";
            case AskTransactionRequest: return "AskTransactionRequest";
            case AskTransactionResponse: return "AskTransactionResponse";
            case CancelCommitRequest: return "CancelCommitRequest";
            case CancelCommitResponse: return "CancelCommitResponse";
            case ChangeSetUpdateRequest: return "ChangeSetUpdateRequest";
            case CloseClientSessionRequest: return "CloseClientSessionRequest";
            case CloseClientSessionResponse: return "CloseClientSessionResponse";
            case EchoRequest: return "EchoRequest";
            case EchoResponse: return "EchoResponse";
            case EndTransactionRequest: return "EndTransactionRequest";
            case EndTransactionResponse: return "EndTransactionResponse";
            case ExceptionRequest: return "ExceptionRequest";
            case ExceptionResponse: return "ExceptionResponse";
            case ExecuteRequest: return "ExecuteRequest";
            case ExecuteResponse: return "ExecuteResponse";
            case GetChangeSetContextRequest: return "GetChangeSetContextRequest";
            case GetChangeSetContextResponse: return "GetChangeSetContextResponse";
            case GetChangeSetDataRequest: return "GetChangeSetDataRequest";
            case GetChangeSetDataResponse: return "GetChangeSetDataResponse";
            case GetChangeSetsRequest: return "GetChangeSetsRequest";
            case GetChangeSetsResponse: return "GetChangeSetsResponse";
            case GetClusterChangesRequest: return "GetClusterChangesRequest";
            case GetClusterChangesResponse: return "GetClusterChangesResponse";
            case GetClusterNewRequest: return "GetClusterNewRequest";
            case GetClusterNewResponse: return "GetClusterNewResponse";
            case GetRefreshRequest: return "GetRefreshRequest";
            case GetRefreshResponse: return "GetRefreshResponse";
            case GetRefresh2Request: return "GetRefresh2Request";
            case GetRefresh2Response: return "GetRefresh2Response";
            case GetResourceSegmentRequest: return "GetResourceSegmentRequest";
            case GetResourceSegmentResponse: return "GetResourceSegmentResponse";
            case GetServerInfoRequest: return "GetServerInfoRequest";
            case GetServerInfoResponse: return "GetServerInfoResponse";
            case GetServerInfo2Request: return "GetServerInfo2Request";
            case GetServerInfo2Response: return "GetServerInfo2Response";
            case ListClustersRequest: return "ListClustersRequest";
            case ListClustersResponse: return "ListClustersResponse";
            case NullRequest: return "NullRequest";
            case NullResponse: return "NullResponse";
            case OpenClientSessionRequest: return "OpenClientSessionRequest";
            case OpenClientSessionResponse: return "OpenClientSessionResponse";
            case ReconnectRequest: return "ReconnectRequest";
            case ReconnectResponse: return "ReconnectResponse";
            case RefreshRequest: return "RefreshRequest";
            case RefreshResponse: return "RefreshResponse";
            case ReserveIdsRequest: return "ReserveIdsRequest";
            case ReserveIdsResponse: return "ReserveIdsResponse";
            case ShoutRequest: return "ShoutRequest";
            case SinkRequest: return "SinkRequest";
            case UndoRequest: return "UndoRequest";
            case UndoResponse: return "UndoResponse";
            case UpdateClusterRequest: return "UpdateClusterRequest";
        }
    }
};
