/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.server.protocol;

import java.nio.ByteOrder;

public class ExceptionFunction extends AbstractFunction {
    public int messageNumber = 0;
    public String what = "";
    public int errorClass = 0;
    public ExceptionFunction() {
        super(MessageNumber.ExceptionRequest, MessageNumber.ExceptionResponse);
    }
    public ExceptionFunction(int messageNumber, String what) {
        super(MessageNumber.ExceptionRequest, MessageNumber.ExceptionResponse);
        this.messageNumber = messageNumber;
        this.what = what;
    }
    @Override
    public DataBuffer serialize(ByteOrder byteOrder) {
        buffer.clear();
        buffer.order(byteOrder);
        buffer.put(messageNumber);
        buffer.put(what);
        buffer.mark();
        return buffer;
    }
    @Override
    public void deserialize(int receivedNumber_, DataBuffer dataBuffer) {
        receivedNumber = receivedNumber_;
        if (notRightDataForUs())
            return;
        messageNumber = dataBuffer.get(messageNumber);
        errorClass = dataBuffer.get(errorClass);
        what = dataBuffer.get(what);
        gotResponse();
    }
}
