/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.server.protocol;

import java.nio.ByteOrder;

public class AskTransactionFunction extends AbstractFunction {
    public int type = 0;
    public long transactionId = 0;
    public long headChangeSetId = 0;
    public AskTransactionFunction() {
        super(MessageNumber.AskTransactionRequest, MessageNumber.AskTransactionResponse);
    }
    public AskTransactionFunction(int type, long transactionId) {
        super(MessageNumber.AskTransactionRequest, MessageNumber.AskTransactionResponse);
        this.type = type;
        this.transactionId = transactionId;
    }
    @Override
    public DataBuffer serialize(ByteOrder byteOrder) {
        buffer.clear();
        buffer.order(byteOrder);
        buffer.put(type);
        buffer.put(transactionId);
        buffer.mark();
        return buffer;
    }
    @Override
    public void deserialize(int receivedNumber_, DataBuffer dataBuffer) {
        receivedNumber = receivedNumber_;
        if (notRightDataForUs())
            return;
        transactionId = dataBuffer.get(transactionId);
        headChangeSetId = dataBuffer.get(headChangeSetId);
        gotResponse();
    }
}
