/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.server.protocol;

public abstract class AbstractEvent extends AbstractMessage {
    protected int token;

    AbstractEvent(int requestNumber, int responseNumber) {
        super(requestNumber, responseNumber);
    }

    @Override
    boolean isEvent() {
        return true;
    }

    boolean notRightDataForUs() {
        return receivedNumber != requestNumber;
    }

    int getToken() {
        return token;
    }

    void setToken(int token) {
        this.token = token;
    }
}
