package org.simantics.db.server.internal;

import org.simantics.db.common.utils.Logger;

public class Util {
    public static void logError(String message) {
        Util.logError(message, null);
    }
    public static void logError(String message, Throwable cause) {
        Logger.defaultLogError(message, cause);
    }
    public static void trace(Class<?> clazz) {
        trace(clazz, null);
    }
    public static void trace(String message) {
        trace(null, message);
    }
    public static void trace(Class<?> clazz, String message) {
        String s = "";
        if (null != clazz)
            s += clazz.getSimpleName() + " called.\n";
        if (null != message)
            s += message;
        Logger.defaultLogTrace(s);
    }
    public static void log(String message) {
        Logger.defaultLog(message);
    }
    public static void showDebug(String message) {
        String t = "DEBUG: " + message;
        System.err.println(t);
    }
}
