/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.procore.cluster;

import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.IntAllocatorI;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.procedure.AsyncMultiProcedure;

final class TableIntSet {
    public static final int HeaderSize = IntHash.HeaderSize;
//    static int create(int initialSize, IntAllocatorI allocator) {
//        return IntHash.create(initialSize, allocator);
//    }
    static int create(int[] ints, IntAllocatorI allocator) {
        return IntHash.create(ints, allocator);
    }

    /**
     * @param table
     * @param base
     * @param object
     * @param allocator
     * @return true if object was actually added.
     */
    static int addInt(int[] table, int base, int object, IntAllocatorI allocator) {
        return IntHash.add(table, base, object, allocator);
    }
    
    static boolean removeInt(int[] table, int base, int object) {
        return IntHash.remove(table, base, object);
    }

    static int removeIntLast(int[] table, int base)
    throws DatabaseException {
        return IntHash.removeLast(table, base);
    }

    static int getSize(int[] table, int base) {
        return IntHash.getUsedSize(table, base);
    }
    
    static int getAllocatedSize(int[] table, int base) {
        return IntHash.getAllocatedSize(table, base);
    }
    
    static void foreachInt(int[] table, int base, QueryProcessor processor, ReadGraphImpl graph, AsyncMultiProcedure<Resource> procedure, Modifier modifier) throws DatabaseException {
        IntHash.foreachInt(graph, table, base, procedure, modifier);
    }

    static <Context> boolean foreachInt(int[] table, int base
    		, ClusterI.ObjectProcedure<Context> procedure, Context context, Modifier modifier) throws DatabaseException {
        return IntHash.foreachInt(table, base, procedure, context, modifier);
    }
    
    static boolean contains(int[] table, int base, int a) {
        return IntHash.contains(table, base, a);
    }
}

