/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package fi.vtt.simantics.procore.internal;

import org.simantics.db.service.ServerInformation;

public class ServerInformationImpl implements ServerInformation {
    final String serverId;
    final String protocolId;
    final String databaseId;
    final long firstChangeSetId;

    // TODO: get this from the server
    // Default UTF-8
    String characterSet = "UTF-8";

    public ServerInformationImpl(String serverId, String protocolId, String databaseId, long firstChangeSetId) {
        this.serverId = serverId;
        this.protocolId = protocolId;
        this.databaseId = databaseId;
        this.firstChangeSetId = firstChangeSetId;
    }

    @Override
    public String getServerId() {
        return serverId;
    }

    @Override
    public String getProtocolId() {
        return protocolId;
    }

    @Override
    public String getDatabaseId() {
        return databaseId;
    }

    @Override
    public long getFirstChangeSetId() {
        return firstChangeSetId;
    }

    @Override
    public String getCharacterSet() {
        return characterSet;
    }

    @Override
    public String toString() {
        return "ServerInformation [server id=" + serverId + ", protocol id=" + protocolId + ", database id=" + databaseId + ", charset=" + characterSet + "]";
    }
}
