/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.EnumerationMap;
import org.simantics.db.common.request.IsEnumeratedValue;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.function.Function4;
import org.simantics.scl.runtime.function.FunctionImpl4;

public class VariableUtils {
    private static final Binding datatype_binding = Bindings.getBindingUnchecked(Datatype.class);
    public static Function4<WriteGraph, Variable, Object, Object, String> defaultInputModifier = new FunctionImpl4<WriteGraph, Variable, Object, Object, String>(){

        public String apply(WriteGraph graph, Variable variable, Object value, Object _binding) {
            try {
                return this.safeApply(graph, variable, value, _binding);
            }
            catch (DatabaseException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
        }

        public String safeApply(WriteGraph graph, Variable variable, Object value, Object _binding) throws DatabaseException {
            Binding binding = (Binding)_binding;
            Variable parent = variable.getParent((ReadGraph)graph);
            Resource property = variable.getPossiblePredicateResource((ReadGraph)graph);
            Resource container = parent.getPossibleRepresents((ReadGraph)graph);
            if (container == null) {
                return null;
            }
            if (property == null) {
                return null;
            }
            CommonDBUtils.selectClusterSet((WriteGraph)graph, (Resource)container);
            Statement object = graph.getPossibleStatement(container, property);
            if (object == null) {
                return null;
            }
            Resource objectResource = object.getObject();
            if (((Boolean)graph.sync((ReadInterface)new IsEnumeratedValue(objectResource))).booleanValue()) {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                Resource type = graph.getSingleObject(objectResource, L0.PartOf);
                Map enumMap = (Map)graph.syncRequest((Read)new EnumerationMap(type));
                Resource newLiteral = (Resource)enumMap.get(value);
                graph.deny(container, property, objectResource);
                graph.claim(container, property, newLiteral);
                return null;
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Statement dt = graph.getPossibleStatement(objectResource, L0.HasDataType);
            if (dt == null) {
                throw new DatabaseException("Can't write variable " + variable.getURI((ReadGraph)graph) + " since its literal resource " + objectResource + " does not contain a datatype statement");
            }
            boolean needsCustomDatatype = !dt.isAsserted(objectResource);
            Datatype correctDatatype = (Datatype)graph.getValue(dt.getObject(), datatype_binding);
            Binding correctBinding = Bindings.getBinding((Datatype)correctDatatype);
            try {
                Adapter adapter = Bindings.getTypeAdapter((Binding)binding, (Binding)correctBinding);
                Object correctValue = adapter.adapt(value);
                if (correctValue == value) {
                    correctBinding = binding;
                }
                value = correctValue;
            }
            catch (AdapterConstructionException adapterConstructionException) {
                throw new DatabaseException("Can't adapt values from source datatype '" + binding.type().toSingleLineString() + "' to target '" + correctDatatype.toSingleLineString() + "'");
            }
            catch (AdaptException adaptException) {
                throw new DatabaseException("Can't adapt value " + value + " from source datatype '" + binding.type().toSingleLineString() + "' to target '" + correctDatatype.toSingleLineString() + "'");
            }
            if (object.isAsserted(container)) {
                String sclType = needsCustomDatatype ? Layer0Utils.getSCLType(correctDatatype) : null;
                Resource type = graph.getPossibleType(objectResource, L0.Literal);
                objectResource = graph.newResource();
                graph.claim(objectResource, L0.InstanceOf, null, type);
                graph.claim(container, property, objectResource);
                if (needsCustomDatatype) {
                    graph.addLiteral(objectResource, L0.HasDataType, L0.HasDataType_Inverse, L0.DataType, (Object)correctDatatype, datatype_binding);
                    graph.addLiteral(objectResource, L0.HasValueType, L0.HasValueType_Inverse, L0.String, (Object)sclType, (Binding)Bindings.STRING);
                }
            }
            graph.claimValue(objectResource, value, correctBinding);
            return null;
        }
    };
}

