/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableValueException;
import org.simantics.db.layer0.variable.AbstractVariable;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;

public abstract class AbstractChildVariable
extends AbstractVariable {
    public AbstractChildVariable() {
        this(null);
    }

    public AbstractChildVariable(VariableNode node) {
        super(node);
    }

    @Override
    public Variables.Role getRole(ReadGraph graph) throws DatabaseException {
        return Variables.Role.CHILD;
    }

    @Override
    public <T> T getValue(ReadGraph graph) throws DatabaseException {
        throw new MissingVariableValueException("No value in child variable.");
    }

    @Override
    public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
        throw new MissingVariableValueException("No value in child variable.");
    }

    @Override
    public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
        throw new DatabaseException("Cannot write value to a child variable.");
    }

    @Override
    public Resource getRepresents(ReadGraph graph) throws DatabaseException {
        Variable parent = this.getParent(graph);
        if (!(parent instanceof AbstractChildVariable)) {
            return null;
        }
        Resource parentRepresents = ((AbstractChildVariable)parent).getRepresentsForBrowsingChildResources(graph);
        if (parentRepresents == null) {
            return null;
        }
        Resource result = (Resource)((Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(parentRepresents))).get(this.getName(graph));
        return result;
    }

    public Resource getRepresentsForBrowsingChildResources(ReadGraph graph) throws DatabaseException {
        return this.getRepresents(graph);
    }

    @Override
    public Variable getPossibleExtraProperty(ReadGraph graph, String name) throws DatabaseException {
        return null;
    }

    @Override
    public void collectExtraProperties(ReadGraph graph, Map<String, Variable> properties) throws DatabaseException {
    }

    @Override
    protected Variable getPossibleDomainProperty(ReadGraph graph, String name) throws DatabaseException {
        return null;
    }

    @Override
    public Variable getPossibleChild(ReadGraph graph, String name) throws DatabaseException {
        return null;
    }

    @Override
    public Map<String, Variable> collectDomainProperties(ReadGraph graph, Map<String, Variable> map) throws DatabaseException {
        return map;
    }

    @Override
    public Collection<Variable> getChildren(ReadGraph graph) throws DatabaseException {
        return Collections.emptyList();
    }

    @Override
    public RVI.RVIPart getRVIPart(ReadGraph graph) throws DatabaseException {
        return new RVI.StringRVIPart(Variables.Role.CHILD, this.getName(graph));
    }

    @Override
    public Set<String> getClassifications(ReadGraph graph) throws DatabaseException {
        return Collections.emptySet();
    }
}

