/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableStringBinding;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.primitives.MutableString;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.type.VariantType;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.datatypes.literal.GUID;
import org.simantics.db.ChangeSetIdentifier;
import org.simantics.db.Metadata;
import org.simantics.db.Operation;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationContext;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.Indexing;
import org.simantics.db.common.StandardStatement;
import org.simantics.db.common.primitiverequest.PossibleRelatedValue;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.DelayedWriteRequest;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleChild;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.event.ChangeListener;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.layer0.adapter.CopyHandler;
import org.simantics.db.layer0.adapter.CopyHandler2;
import org.simantics.db.layer0.adapter.GenericRelationIndex;
import org.simantics.db.layer0.adapter.PasteHandler;
import org.simantics.db.layer0.adapter.impl.DefaultPasteHandler;
import org.simantics.db.layer0.adapter.impl.EntityRemover;
import org.simantics.db.layer0.adapter.impl.TGRemover;
import org.simantics.db.layer0.genericrelation.IndexedRelations;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.layer0.migration.OntologiesFromLibrary;
import org.simantics.db.layer0.property.OrderedResource;
import org.simantics.db.layer0.request.GlobalOntologies;
import org.simantics.db.layer0.request.PossibleVariableIndexRoot;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.ModelTransferableGraphSource;
import org.simantics.db.layer0.util.PasteEventHandler;
import org.simantics.db.layer0.util.RelationContextImpl;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.util.RuntimeEnvironmentRequest;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.DelayedWrite;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.service.ClusterCollectorPolicy;
import org.simantics.db.service.ClusterControl;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.CollectionSupport;
import org.simantics.db.service.DebugSupport;
import org.simantics.db.service.GraphChangeListenerSupport;
import org.simantics.db.service.ManagementSupport;
import org.simantics.db.service.UndoRedoSupport;
import org.simantics.db.service.XSupport;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.diff.Diff;
import org.simantics.graph.diff.TransferableGraphDelta1;
import org.simantics.graph.refactoring.GraphRefactoringUtils;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.PrettyPrintTG;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.FunctionImpl1;

public class Layer0Utils {
    public static final ThreadLocal SCL_GRAPH = new ThreadLocal();
    public static final Binding datatype_binging = Bindings.getBindingUnchecked(Datatype.class);
    public static final Function1<Resource, Resource> resourceCluster = new FunctionImpl1<Resource, Resource>(){

        public Resource apply(Resource p0) {
            return p0;
        }
    };

    public static Resource literal(WriteGraph g, String value) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource r = g.newResource();
        g.claimValue(r, (Object)value, (Binding)Bindings.STRING);
        g.claim(r, L0.InstanceOf, L0.String);
        return r;
    }

    public static Resource literal(WriteGraph g, double value) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource r = g.newResource();
        g.claimValue(r, (Object)value, (Binding)Bindings.DOUBLE);
        g.claim(r, L0.InstanceOf, L0.Double);
        return r;
    }

    public static Resource literal(WriteGraph g, int value) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource r = g.newResource();
        g.claimValue(r, (Object)value, (Binding)Bindings.INTEGER);
        g.claim(r, L0.InstanceOf, L0.Integer);
        return r;
    }

    public static void assert_(WriteGraph g, Resource type, Resource predicate, Resource object) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource assertion = g.newResource();
        g.claim(type, L0.Asserts, assertion);
        g.claim(assertion, L0.InstanceOf, L0.Assertion);
        g.claim(assertion, L0.HasPredicate, predicate);
        g.claim(assertion, L0.HasObject, object);
    }

    public static Resource relation(WriteGraph g, Resource parent, String name, Resource superrelation) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource relation = g.newResource();
        g.claim(relation, L0.SubrelationOf, superrelation);
        g.claim(relation, L0.HasName, Layer0Utils.literal(g, name));
        g.claim(parent, L0.ConsistsOf, relation);
        Resource superrelationInverse = g.getInverse(superrelation);
        if (superrelationInverse != null) {
            Resource inverse = g.newResource();
            g.claim(inverse, L0.SubrelationOf, superrelationInverse);
            g.claim(relation, L0.ConsistsOf, inverse);
            g.claim(inverse, L0.HasName, Layer0Utils.literal(g, "Inverse"));
        }
        return relation;
    }

    private static Resource getLiteralType(ReadGraph graph, Datatype type) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (type instanceof DoubleType) {
            return L0.Double;
        }
        if (type instanceof StringType) {
            return L0.String;
        }
        if (type instanceof IntegerType) {
            return L0.Integer;
        }
        if (type instanceof LongType) {
            return L0.Long;
        }
        if (type instanceof FloatType) {
            return L0.Float;
        }
        if (type instanceof ByteType) {
            return L0.Byte;
        }
        if (type instanceof BooleanType) {
            return L0.Boolean;
        }
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            if (at.componentType instanceof DoubleType) {
                return L0.DoubleArray;
            }
            if (at.componentType instanceof StringType) {
                return L0.StringArray;
            }
            if (at.componentType instanceof IntegerType) {
                return L0.IntegerArray;
            }
            if (at.componentType instanceof LongType) {
                return L0.LongArray;
            }
            if (at.componentType instanceof FloatType) {
                return L0.FloatArray;
            }
            if (at.componentType instanceof ByteType) {
                return L0.ByteArray;
            }
            if (at.componentType instanceof BooleanType) {
                return L0.BooleanArray;
            }
            if (at.componentType instanceof VariantType) {
                return L0.VariantArray;
            }
        }
        throw new DatabaseException("Unidentified literal type for datatype " + type);
    }

    private static Resource getPossibleLiteralType(ReadGraph graph, String type) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if ("Double".equals(type)) {
            return L0.Double;
        }
        if ("String".equals(type)) {
            return L0.String;
        }
        if ("Integer".equals(type)) {
            return L0.Integer;
        }
        if ("Long".equals(type)) {
            return L0.Long;
        }
        if ("Float".equals(type)) {
            return L0.Float;
        }
        if ("Byte".equals(type)) {
            return L0.Byte;
        }
        if ("Boolean".equals(type)) {
            return L0.Boolean;
        }
        if ("[Double]".equals(type)) {
            return L0.DoubleArray;
        }
        if ("[String]".equals(type)) {
            return L0.StringArray;
        }
        if ("[Integer]".equals(type)) {
            return L0.IntegerArray;
        }
        if ("[Long]".equals(type)) {
            return L0.LongArray;
        }
        if ("[Float]".equals(type)) {
            return L0.FloatArray;
        }
        if ("[Byte]".equals(type)) {
            return L0.ByteArray;
        }
        if ("[Boolean]".equals(type)) {
            return L0.BooleanArray;
        }
        if ("[Variant]".equals(type)) {
            return L0.VariantArray;
        }
        if ("Array Double".equals(type)) {
            return L0.DoubleArray;
        }
        if ("Array String".equals(type)) {
            return L0.StringArray;
        }
        if ("Array Integer".equals(type)) {
            return L0.IntegerArray;
        }
        if ("Array Long".equals(type)) {
            return L0.LongArray;
        }
        if ("Array Float".equals(type)) {
            return L0.FloatArray;
        }
        if ("Array Byte".equals(type)) {
            return L0.ByteArray;
        }
        if ("Array Boolean".equals(type)) {
            return L0.BooleanArray;
        }
        if ("Array Variant".equals(type)) {
            return L0.VariantArray;
        }
        if ("Vector Double".equals(type)) {
            return L0.DoubleArray;
        }
        if ("Vector String".equals(type)) {
            return L0.StringArray;
        }
        if ("Vector Integer".equals(type)) {
            return L0.IntegerArray;
        }
        if ("Vector Long".equals(type)) {
            return L0.LongArray;
        }
        if ("Vector Float".equals(type)) {
            return L0.FloatArray;
        }
        if ("Vector Byte".equals(type)) {
            return L0.ByteArray;
        }
        if ("Vector Boolean".equals(type)) {
            return L0.BooleanArray;
        }
        if ("Vector Variant".equals(type)) {
            return L0.VariantArray;
        }
        if ("Datatype".equals(type)) {
            return L0.DataType;
        }
        if ("Variant".equals(type)) {
            return L0.Variant;
        }
        return null;
    }

    public static Resource getPossibleLiteralType(ReadGraph graph, Variable variable) throws DatabaseException {
        Resource predicate = variable.getPossiblePredicateResource(graph);
        if (predicate == null) {
            return null;
        }
        return Layer0Utils.getPossibleLiteralType(graph, predicate);
    }

    public static Resource getLiteralType(ReadGraph graph, Variable variable) throws DatabaseException {
        Resource result = Layer0Utils.getPossibleLiteralType(graph, variable);
        if (result == null) {
            throw new DatabaseException("Unidentified literal type for variable " + variable.getURI(graph));
        }
        return result;
    }

    public static Resource getLiteralType(ReadGraph graph, Resource property) throws DatabaseException {
        Resource result = Layer0Utils.getPossibleLiteralType(graph, property);
        if (result == null) {
            throw new DatabaseException("Unidentified literal type for property " + graph.getURI(property));
        }
        return result;
    }

    public static Resource getPossibleLiteralType(ReadGraph graph, Resource property) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        Resource defaultLiteralType = graph.getPossibleObject(property, L0.HasDefaultLiteralType);
        if (defaultLiteralType != null) {
            return defaultLiteralType;
        }
        Resource range = graph.getPossibleObject(property, L0.HasRange);
        if (range != null && !L0.Value.equals(range)) {
            return range;
        }
        Datatype requiredDataType = (Datatype)graph.getPossibleRelatedValue(property, L0X.RequiresDataType, datatype_binging);
        if (requiredDataType != null) {
            return Layer0Utils.getLiteralType(graph, requiredDataType);
        }
        String requiredValueType = (String)graph.getPossibleRelatedValue(property, L0.RequiresValueType, (Binding)Bindings.STRING);
        if (requiredValueType == null) {
            return null;
        }
        return Layer0Utils.getPossibleLiteralType(graph, requiredValueType);
    }

    public static String getSCLType(Datatype type) throws IllegalArgumentException {
        return Layer0Utils.buildSCLType(type, null).toString();
    }

    private static StringBuilder append(StringBuilder toBuilder, String s) {
        return toBuilder != null ? toBuilder.append(s) : new StringBuilder(s);
    }

    private static CharSequence append(CharSequence to, String s) {
        if (to instanceof StringBuilder) {
            return ((StringBuilder)to).append(s);
        }
        return new StringBuilder(to.length() + s.length()).append(to).append(s);
    }

    private static CharSequence stringOrBuilder(StringBuilder toBuilder, String s) {
        return toBuilder != null ? toBuilder.append(s) : s;
    }

    private static CharSequence buildSCLType(Datatype type, StringBuilder result) throws IllegalArgumentException {
        if (type instanceof DoubleType) {
            return Layer0Utils.stringOrBuilder(result, "Double");
        }
        if (type instanceof StringType) {
            return Layer0Utils.stringOrBuilder(result, "String");
        }
        if (type instanceof IntegerType) {
            return Layer0Utils.stringOrBuilder(result, "Integer");
        }
        if (type instanceof FloatType) {
            return Layer0Utils.stringOrBuilder(result, "Float");
        }
        if (type instanceof BooleanType) {
            return Layer0Utils.stringOrBuilder(result, "Boolean");
        }
        if (type instanceof ByteType) {
            return Layer0Utils.stringOrBuilder(result, "Byte");
        }
        if (type instanceof LongType) {
            return Layer0Utils.stringOrBuilder(result, "Long");
        }
        if (type instanceof VariantType) {
            return Layer0Utils.stringOrBuilder(result, "Variant");
        }
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            if (at.componentType instanceof DoubleType) {
                return Layer0Utils.stringOrBuilder(result, "Vector Double");
            }
            if (at.componentType instanceof StringType) {
                return Layer0Utils.stringOrBuilder(result, "Vector String");
            }
            if (at.componentType instanceof IntegerType) {
                return Layer0Utils.stringOrBuilder(result, "Vector Integer");
            }
            if (at.componentType instanceof FloatType) {
                return Layer0Utils.stringOrBuilder(result, "Vector Float");
            }
            if (at.componentType instanceof BooleanType) {
                return Layer0Utils.stringOrBuilder(result, "Vector Boolean");
            }
            if (at.componentType instanceof ByteType) {
                return Layer0Utils.stringOrBuilder(result, "Vector Byte");
            }
            if (at.componentType instanceof LongType) {
                return Layer0Utils.stringOrBuilder(result, "Vector Long");
            }
            if (at.componentType instanceof VariantType) {
                return Layer0Utils.stringOrBuilder(result, "Vector Variant");
            }
            return Layer0Utils.buildSCLType(at.componentType, Layer0Utils.append(result, "Vector "));
        }
        if (type instanceof OptionalType) {
            OptionalType ot = (OptionalType)type;
            return Layer0Utils.append(Layer0Utils.buildSCLType(ot.componentType, Layer0Utils.append(result, "Maybe (")), ")");
        }
        if (type instanceof RecordType) {
            throw new IllegalArgumentException("Unable to convert datatype into SCL type: " + type);
        }
        if (type instanceof MapType) {
            throw new IllegalArgumentException("Unable to convert datatype into SCL type: " + type);
        }
        if (type instanceof UnionType) {
            throw new IllegalArgumentException("Unable to convert datatype into SCL type: " + type);
        }
        throw new IllegalArgumentException("Unable to convert datatype into SCL type: " + type);
    }

    public static Type getSCLType(ReadGraph graph, RuntimeEnvironment runtimeEnvironment, String typeText) throws DatabaseException {
        try {
            return Environments.getType((Environment)runtimeEnvironment.getEnvironment(), (String)typeText);
        }
        catch (SCLExpressionCompilationException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static Type getSCLType(ReadGraph graph, Variable property) throws DatabaseException {
        RuntimeEnvironment runtimeEnvironment = (RuntimeEnvironment)graph.syncRequest((Read)new RuntimeEnvironmentRequest(property.getIndexRoot(graph)));
        return Layer0Utils.getSCLType(graph, runtimeEnvironment, Layer0Utils.getSCLTypeString(graph, property));
    }

    public static String getSCLTypeString(ReadGraph graph, Variable context) throws DatabaseException {
        return Layer0Utils.getSCLTypeString(graph, context.getPossiblePredicateResource(graph), context.getRepresents(graph));
    }

    public static String getSCLTypeString(ReadGraph graph, Resource predicate, Resource value) throws DatabaseException {
        String requiredValueTypes;
        if (predicate != null && (requiredValueTypes = (String)graph.getPossibleRelatedValue(predicate, Layer0.getInstance((ReadGraph)graph).RequiresValueType, (Binding)Bindings.STRING)) != null) {
            return requiredValueTypes;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        Datatype literalDatatype = (Datatype)graph.getPossibleRelatedValue(value, L0.HasDataType, datatype_binging);
        if (literalDatatype != null) {
            return Layer0Utils.getSCLType(literalDatatype);
        }
        String literalValueType = (String)graph.getPossibleRelatedValue(value, L0.HasValueType, (Binding)Bindings.STRING);
        if (literalValueType != null) {
            return literalValueType;
        }
        if (predicate != null) {
            Datatype requiredDataType = (Datatype)graph.getPossibleRelatedValue(predicate, L0X.RequiresDataType, datatype_binging);
            if (requiredDataType != null) {
                return Layer0Utils.getSCLType(requiredDataType);
            }
            throw new DatabaseException("Unidentified literal data type for property " + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)predicate));
        }
        throw new DatabaseException("Unidentified literal data type");
    }

    public static Datatype getDatatype(ReadGraph graph, Variable variable) throws DatabaseException {
        Datatype result = Layer0Utils.getPossibleDatatype(graph, variable);
        if (result != null) {
            return result;
        }
        throw new DatabaseException("Unidentified literal data type for property " + variable.getURI(graph));
    }

    public static Datatype getPossibleDatatype(ReadGraph graph, Variable variable) throws DatabaseException {
        Datatype literalDatatype;
        Datatype requiredDataType;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        Resource property = variable.getPossiblePredicateResource(graph);
        if (property != null && (requiredDataType = (Datatype)graph.syncRequest((Read)new PossibleRelatedValue(property, L0X.RequiresDataType, datatype_binging))) != null) {
            return requiredDataType;
        }
        Resource literal = variable.getPossibleRepresents(graph);
        if (literal != null && (literalDatatype = (Datatype)graph.getPossibleRelatedValue2(literal, L0.HasDataType, (Object)new StandardGraphPropertyVariable(graph, variable, null, literal, L0.HasDataType), datatype_binging)) != null) {
            return literalDatatype;
        }
        if (property != null) {
            Datatype datatype;
            String requiredValueType = (String)graph.getPossibleRelatedValue(property, L0.RequiresValueType, (Binding)Bindings.STRING);
            if (requiredValueType != null && (datatype = Layer0Utils.getPossibleDatatypeForValueType(requiredValueType)) != null) {
                return datatype;
            }
            Resource subject = variable.getParent(graph).getPossibleRepresents(graph);
            if (subject != null) {
                Resource ass;
                Datatype dt;
                HashSet asses = new HashSet();
                for (Resource type : graph.getTypes(subject)) {
                    asses.addAll(graph.getAssertedObjects(type, property));
                }
                if (asses.size() == 1 && (dt = (Datatype)graph.getPossibleRelatedValue(ass = (Resource)asses.iterator().next(), L0.HasDataType, Bindings.getBindingUnchecked(Datatype.class))) != null) {
                    return dt;
                }
            }
        }
        return null;
    }

    private static Datatype getPossibleDatatypeForValueType(String requiredValueType) throws DatabaseException {
        Datatype arrayDataType;
        String[] split = requiredValueType.split(" ");
        String arrayType = null;
        if (split.length == 2 && "Array".equals(split[0])) {
            arrayType = split[1];
        } else if (requiredValueType.startsWith("[") && requiredValueType.endsWith("]")) {
            arrayType = requiredValueType.substring(1, requiredValueType.length() - 1);
        }
        if (arrayType != null && (arrayDataType = Layer0Utils.getArrayDataTypeForType(arrayType)) != null) {
            return arrayDataType;
        }
        Datatype dt = Datatypes.getDatatype((String)requiredValueType);
        if (dt != null) {
            return dt;
        }
        try {
            return Datatypes.translate((String)requiredValueType);
        }
        catch (DataTypeSyntaxError dataTypeSyntaxError) {
            return null;
        }
    }

    private static Datatype getArrayDataTypeForType(String type) {
        if ("Double".equals(type)) {
            return Datatypes.DOUBLE_ARRAY;
        }
        if ("String".equals(type)) {
            return Datatypes.STRING_ARRAY;
        }
        if ("Integer".equals(type)) {
            return Datatypes.INTEGER_ARRAY;
        }
        if ("Long".equals(type)) {
            return Datatypes.LONG_ARRAY;
        }
        if ("Float".equals(type)) {
            return Datatypes.FLOAT_ARRAY;
        }
        if ("Byte".equals(type)) {
            return Datatypes.BYTE_ARRAY;
        }
        if ("Boolean".equals(type)) {
            return Datatypes.BOOLEAN_ARRAY;
        }
        if ("Variant".equals(type)) {
            return Datatypes.VARIANT_ARRAY;
        }
        return null;
    }

    public static Binding getDefaultBinding(ReadGraph graph, Variable variable) throws DatabaseException {
        Datatype type;
        Resource property = variable.getPossiblePredicateResource(graph);
        if (property != null) {
            PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(property), (AsyncProcedure)TransientCacheAsyncListener.instance());
            if (info.defaultBinding != null) {
                return info.defaultBinding;
            }
        }
        if ((type = Layer0Utils.getDatatype(graph, variable)) == null) {
            throw new DatabaseException("No datatype available for variable " + variable.getURI(graph));
        }
        return Bindings.getBinding((Datatype)type);
    }

    public static Binding getPossibleDefaultBinding(ReadGraph graph, Variable variable) throws DatabaseException {
        Datatype type;
        Resource property = variable.getPossiblePredicateResource(graph);
        if (property != null) {
            PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(property), (AsyncProcedure)TransientCacheAsyncListener.instance());
            if (info.defaultBinding != null) {
                return info.defaultBinding;
            }
        }
        if ((type = Layer0Utils.getPossibleDatatype(graph, variable)) == null) {
            return null;
        }
        return Bindings.getBinding((Datatype)type);
    }

    public static String getPossibleUnit(Datatype dt) {
        ArrayType at;
        Datatype cdt;
        if (dt == null) {
            return null;
        }
        if (dt instanceof NumberType) {
            return ((NumberType)dt).getUnit();
        }
        if (dt instanceof ArrayType && (cdt = (at = (ArrayType)dt).componentType()) instanceof NumberType) {
            return ((NumberType)cdt).getUnit();
        }
        return null;
    }

    public static String getUnit(ReadGraph graph, Variable variable) throws DatabaseException {
        String unit;
        Datatype requiredDataType;
        String unit2;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        Resource literal = variable.getPossibleRepresents(graph);
        if (literal == null) {
            return "";
        }
        Datatype literalDatatype = (Datatype)graph.getPossibleRelatedValue2(literal, L0.HasDataType, (Object)new StandardGraphPropertyVariable(graph, variable, null, literal, L0.HasDataType), datatype_binging);
        if (literalDatatype != null && (unit2 = Layer0Utils.getPossibleUnit(literalDatatype)) != null) {
            return unit2;
        }
        Resource property = variable.getPossiblePredicateResource(graph);
        if (property != null && (requiredDataType = (Datatype)graph.getPossibleRelatedValue(property, L0X.RequiresDataType, datatype_binging)) != null && (unit = Layer0Utils.getPossibleUnit(requiredDataType)) != null) {
            return unit;
        }
        return "";
    }

    public static void claimAdaptedValue(WriteGraph graph, Resource objectResource, Object value, Binding binding, Datatype targetDatatype) throws DatabaseException {
        try {
            Datatype sourceDatatype = binding.type();
            if (sourceDatatype.equals((Object)targetDatatype)) {
                graph.claimValue(objectResource, value, binding);
            } else {
                Binding target = Bindings.getBinding((Datatype)targetDatatype);
                Adapter adapter = Bindings.getTypeAdapter((Binding)binding, (Binding)target);
                graph.claimValue(objectResource, adapter.adapt(value), target);
            }
        }
        catch (AdapterConstructionException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (AdaptException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static String toString(Object value, Binding binding) throws DatabaseException {
        try {
            if (value instanceof String) {
                return (String)value;
            }
            StringBuilder sb = new StringBuilder();
            DataValueRepository rep = new DataValueRepository();
            binding.printValue(value, (Appendable)sb, rep, false);
            return sb.toString();
        }
        catch (BindingException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static Object parseValue(String text, Binding binding) throws DatabaseException {
        try {
            if (binding.isInstance((Object)text)) {
                return text;
            }
            DataValueRepository rep = new DataValueRepository();
            return binding.parseValue(text, rep);
        }
        catch (BindingException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (DataTypeSyntaxError e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static <T> T getValueAdaptedToBinding(ReadGraph graph, Resource literal, Binding targetBinding) throws DatabaseException {
        Datatype targetDatatype;
        Datatype sourceDatatype = graph.getDataType(literal);
        if (sourceDatatype.equals((Object)(targetDatatype = targetBinding.type()))) {
            return (T)graph.getValue(literal, targetBinding);
        }
        Binding sourceBinding = Bindings.getBinding((Datatype)sourceDatatype);
        try {
            Adapter adapter = Bindings.adapterFactory.getAdapter(Bindings.getBinding((Datatype)sourceDatatype), targetBinding, true, false);
            Object value = graph.getValue(literal, sourceBinding);
            return (T)adapter.adaptUnchecked(value);
        }
        catch (AdapterConstructionException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static Statement getStatementInLocal(Resource subject, Statement statement) {
        if (statement.isAsserted(subject)) {
            return new StandardStatement(subject, statement.getPredicate(), statement.getObject());
        }
        return statement;
    }

    public static Resource browsePossible(ReadGraph graph, Resource root, String suffix) throws DatabaseException {
        return graph.getPossibleResource(String.valueOf(graph.getURI(root)) + suffix);
    }

    public static Resource getPossibleChild(ReadGraph graph, Resource resource, String name) throws DatabaseException {
        return (Resource)graph.sync((ReadInterface)new PossibleChild(resource, name));
    }

    public static Resource getPossibleChild(ReadGraph graph, Resource resource, Resource type, String name) throws DatabaseException {
        Resource child = (Resource)graph.sync((ReadInterface)new PossibleChild(resource, name));
        if (child == null) {
            return null;
        }
        if (!graph.isInstanceOf(child, type)) {
            return null;
        }
        return child;
    }

    public static RelationContext relationContext(ReadGraph graph, Resource subject, Resource predicate) throws DatabaseException {
        Statement stm = graph.getSingleStatement(subject, predicate);
        return new RelationContextImpl(subject, stm);
    }

    public static RelationContext relationContext(Statement stm) throws DatabaseException {
        return new RelationContextImpl(stm.getSubject(), stm);
    }

    public static <T> T valueInRelationContext(ReadGraph graph, Resource subject, Statement stm) throws DatabaseException {
        return (T)graph.getValue2(subject, (Object)Layer0Utils.relationContext(stm));
    }

    public static <T> T valueInRelationContext(ReadGraph graph, Resource subject, Statement stm, Binding binding) throws DatabaseException {
        return (T)graph.getValue2(subject, (Object)Layer0Utils.relationContext(stm), binding);
    }

    public static <T> T relatedValueInRelationContext(ReadGraph graph, Resource subject, Resource relation) throws DatabaseException {
        Statement stm = Layer0Utils.getStatementInLocal(subject, graph.getSingleStatement(subject, relation));
        return Layer0Utils.valueInRelationContext(graph, stm.getObject(), stm);
    }

    public static <T> T relatedValueInRelationContext(ReadGraph graph, Resource subject, Resource relation, Binding binding) throws DatabaseException {
        Statement stm = Layer0Utils.getStatementInLocal(subject, graph.getSingleStatement(subject, relation));
        return Layer0Utils.valueInRelationContext(graph, stm.getObject(), stm, binding);
    }

    public static Statement possibleObtainedStatementInternal(ReadGraph graph, Resource subject, Resource relation) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        for (Resource ob : graph.getObjects(subject, L0X.DefinesObtainedStatement)) {
            Resource pred = graph.getSingleObject(ob, L0X.ObtainedStatement_predicate);
            if (!graph.isSubrelationOf(pred, relation)) continue;
            Resource object = graph.getSingleObject(ob, L0X.ObtainedStatement_object);
            return new StandardStatement(subject, pred, object);
        }
        ArrayList<OrderedResource> order = new ArrayList<OrderedResource>();
        for (Statement stm : graph.getStatements(subject, L0X.ObtainsProperty)) {
            Integer position = (Integer)graph.getRelatedValue(stm.getPredicate(), L0X.NaturalNumberOrderRelation, (Binding)Bindings.INTEGER);
            order.add(new OrderedResource(position, stm.getObject()));
        }
        for (OrderedResource or : order) {
            Statement stm = Layer0Utils.possibleObtainedStatementInternal(graph, or.r, relation);
            if (stm == null) continue;
            return stm;
        }
        return null;
    }

    public static <T> T possibleObtainedValue(ReadGraph graph, RelationContext ctx, Binding binding) throws DatabaseException {
        Statement stm = ctx.getStatement();
        Statement obj = Layer0Utils.possibleObtainedStatementInternal(graph, stm.getSubject(), stm.getPredicate());
        if (obj != null) {
            return Layer0Utils.valueInRelationContext(graph, obj.getObject(), obj, binding);
        }
        return null;
    }

    public static void addObtainedStatement(WriteGraph graph, Resource subject, Resource predicate, Resource object) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        Resource ob = graph.newResource();
        graph.claim(ob, L0.InstanceOf, null, L0X.ObtainedStatement);
        graph.claim(ob, L0X.ObtainedStatement_predicate, null, predicate);
        graph.claim(ob, L0X.ObtainedStatement_object, null, object);
        graph.claim(subject, L0X.DefinesObtainedStatement, null, ob);
    }

    public static void addObtainedValue(WriteGraph graph, Resource subject, Resource predicate, Resource type, Object value, Binding binding) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource object = graph.newResource();
        graph.claim(object, L0.InstanceOf, type);
        graph.claimValue(object, value, binding);
        Layer0Utils.addObtainedStatement(graph, subject, predicate, object);
    }

    public static void waitIndexPending() {
        Indexing.waitIndexPending();
    }

    public static boolean setDependenciesIndexingDisabled(WriteOnlyGraph graph, boolean disabled) {
        return Indexing.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)disabled);
    }

    public static String undo() throws DatabaseException {
        Session session = SimanticsInternal.getSession();
        UndoRedoSupport support = (UndoRedoSupport)session.getService(UndoRedoSupport.class);
        List ops = support.undoAndReturnOperations(session, 1);
        if (ops.isEmpty()) {
            return "Undo history is empty.";
        }
        Operation mainOperation = (Operation)ops.get(0);
        long csId = mainOperation.getCSId();
        ManagementSupport management = (ManagementSupport)session.getService(ManagementSupport.class);
        Collection ids = management.getChangeSetIdentifiers(csId, csId);
        return "Undo reverted " + ids.size() + " change sets.";
    }

    public static String undoOperations(int amountOfOperations) throws DatabaseException {
        Session session = SimanticsInternal.getSession();
        UndoRedoSupport support = (UndoRedoSupport)session.getService(UndoRedoSupport.class);
        List ops = support.undoAndReturnOperations(session, amountOfOperations);
        if (ops.isEmpty()) {
            return "Undo history is empty.";
        }
        Operation mainOperation = (Operation)ops.get(0);
        long csId = mainOperation.getCSId();
        ManagementSupport management = (ManagementSupport)session.getService(ManagementSupport.class);
        Collection ids = management.getChangeSetIdentifiers(csId, csId);
        return "Undo reverted " + ids.size() + " change sets.";
    }

    public static String redo() throws DatabaseException {
        Session session = SimanticsInternal.getSession();
        UndoRedoSupport support = (UndoRedoSupport)session.getService(UndoRedoSupport.class);
        List ops = support.redo(session, 1);
        if (ops.isEmpty()) {
            return "Redo history is empty.";
        }
        Operation mainOperation = (Operation)ops.get(0);
        long csId = mainOperation.getCSId();
        ManagementSupport management = (ManagementSupport)session.getService(ManagementSupport.class);
        Collection ids = management.getChangeSetIdentifiers(csId, csId);
        return "Redo redid " + ids.size() + " change sets.";
    }

    public static String getComment(Session session, ChangeSetIdentifier id) {
        byte[] data = (byte[])id.getMetadata().get(CommentMetadata.class.getName());
        if (data == null) {
            return "Undescribed operation.";
        }
        String comment = CommentMetadata.deserialise((Session)session, (byte[])data).toString().trim();
        if (comment.isEmpty()) {
            return "Undescribed operation.";
        }
        return comment;
    }

    public static void addCommentMetadata(WriteOnlyGraph graph, String string) throws ServiceException {
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add(ObjectUtils.toString((Object)string)));
    }

    public static Collection<Resource> copyTo(WriteGraph graph, Resource targetContainer, Resource source) throws DatabaseException {
        return Layer0Utils.copyTo(graph, targetContainer, source, null, null, null);
    }

    public static Collection<Resource> copyTo(WriteGraph graph, Resource targetContainer, Resource source, PasteEventHandler handler) throws DatabaseException {
        return Layer0Utils.copyTo(graph, targetContainer, source, handler, null, null);
    }

    public static Collection<Resource> copyTo(WriteGraph graph, Resource targetContainer, Resource source, PasteEventHandler handler, CopyHandler copyHandler, PasteHandler pasteHandler) throws DatabaseException {
        if (copyHandler == null) {
            copyHandler = (CopyHandler)graph.adapt(source, CopyHandler.class);
        }
        return Layer0Utils.copyTo(graph, targetContainer, handler, copyHandler, pasteHandler);
    }

    public static Collection<Resource> copyTo(WriteGraph graph, Resource targetContainer, PasteEventHandler handler, CopyHandler copyHandler, PasteHandler pasteHandler) throws DatabaseException {
        SimanticsClipboardImpl clipboard = new SimanticsClipboardImpl();
        copyHandler.copyToClipboard((ReadGraph)graph, clipboard);
        if (targetContainer != null) {
            if (pasteHandler == null) {
                pasteHandler = (PasteHandler)graph.adapt(targetContainer, PasteHandler.class);
            }
            return pasteHandler.pasteFromClipboard(graph, clipboard, handler);
        }
        DefaultPasteHandler ph = new DefaultPasteHandler(null);
        return ph.pasteFromClipboard(graph, clipboard, handler);
    }

    public static CopyHandler2 getPossibleCopyHandler(ReadGraph graph, Collection<Resource> rs) throws DatabaseException {
        CopyHandler2 ch = null;
        for (Resource r : rs) {
            CopyHandler ch2_;
            if (ch == null) {
                ch2_ = (CopyHandler)graph.adapt(r, CopyHandler.class);
                if (!(ch2_ instanceof CopyHandler2)) continue;
                ch = (CopyHandler2)ch2_;
                continue;
            }
            ch2_ = (CopyHandler)graph.adapt(r, CopyHandler.class);
            if (!(ch2_ instanceof CopyHandler2)) continue;
            CopyHandler2 ch2 = (CopyHandler2)ch2_;
            ch = ch.combine(ch2);
        }
        return ch;
    }

    public static ClusterCollectorPolicy setClusterCollectorPolicy(ClusterCollectorPolicy policy) {
        Session session = SimanticsInternal.getSession();
        ClusterControl cc = (ClusterControl)session.getService(ClusterControl.class);
        return cc.setPolicy(policy);
    }

    private static String decodeType(ReadGraph graph, Variable variable) throws DatabaseException {
        Datatype dt = Layer0Utils.getDatatype(graph, variable);
        return dt.toSingleLineString();
    }

    private static boolean isAsserted(ReadGraph graph, Resource subject, Resource predicate) throws DatabaseException {
        Statement stm = graph.getPossibleStatement(subject, predicate);
        return stm != null && stm.isAsserted(subject);
    }

    public static void setExpression(WriteGraph graph, Variable context, String text, Resource expressionValueType) throws DatabaseException {
        Resource value = context.getRepresents((ReadGraph)graph);
        Resource predicateResource = context.getPredicateResource((ReadGraph)graph);
        Variable parent = context.getParent((ReadGraph)graph);
        Resource parentResource = parent.getRepresents((ReadGraph)graph);
        Layer0Utils.setExpression(graph, parentResource, predicateResource, value, text, expressionValueType);
    }

    public static void setExpression(WriteGraph graph, Resource parentResource, Resource predicateResource, Resource value, String text, Resource expressionValueType) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        boolean hasExpression = graph.isInstanceOf(value, expressionValueType);
        String t = Layer0Utils.getSCLTypeString((ReadGraph)graph, predicateResource, value);
        String expression = text.substring(1).trim();
        if (Layer0Utils.isAsserted((ReadGraph)graph, parentResource, predicateResource)) {
            Resource newValue = graph.newResource();
            graph.claim(newValue, L0.InstanceOf, expressionValueType);
            graph.claimLiteral(newValue, L0.HasValueType, (Object)t, (Binding)Bindings.STRING);
            graph.claimLiteral(newValue, L0.SCLValue_expression, (Object)expression, (Binding)Bindings.STRING);
            graph.claim(parentResource, predicateResource, newValue);
        } else if (hasExpression) {
            graph.claimLiteral(value, L0.SCLValue_expression, (Object)expression, (Binding)Bindings.STRING);
        } else {
            Resource newValue = graph.newResource();
            graph.claim(newValue, L0.InstanceOf, expressionValueType);
            graph.claimLiteral(newValue, L0.HasValueType, (Object)t, (Binding)Bindings.STRING);
            graph.claimLiteral(newValue, L0.SCLValue_expression, (Object)expression, (Binding)Bindings.STRING);
            graph.deny(parentResource, predicateResource);
            graph.claim(parentResource, predicateResource, newValue);
        }
    }

    public static void clearExpression(WriteGraph graph, Variable property, Resource expressionValueType) throws DatabaseException {
        Resource predicate;
        Resource subject;
        boolean hasExpression;
        Resource object = property.getPossibleRepresents((ReadGraph)graph);
        if (object != null && (hasExpression = graph.isInstanceOf(object, expressionValueType)) && (subject = property.getParent((ReadGraph)graph).getPossibleRepresents((ReadGraph)graph)) != null && (predicate = property.getPossiblePredicateResource((ReadGraph)graph)) != null) {
            graph.deny(subject, predicate, object);
            RemoverUtil.remove(graph, object);
        }
    }

    public static boolean setOrClearExpression(WriteGraph graph, Variable property, String text, Resource expressionValueType) throws DatabaseException {
        if (text.startsWith("=")) {
            Layer0Utils.setExpression(graph, property, text, expressionValueType);
            return true;
        }
        Layer0Utils.clearExpression(graph, property, expressionValueType);
        return false;
    }

    public static void setValueAsString(WriteGraph graph, Variable property, String text, Resource expressionValueType) throws DatabaseException {
        try {
            if (Layer0Utils.setOrClearExpression(graph, property, text, expressionValueType)) {
                return;
            }
            Object value = text;
            Datatype type = property.getPossibleDatatype((ReadGraph)graph);
            if (type != null) {
                Binding binding = Bindings.getBinding((Datatype)type);
                if (binding instanceof StringBinding) {
                    value = binding instanceof MutableStringBinding ? new MutableString(text) : text;
                } else {
                    if (binding instanceof NumberBinding) {
                        text = text.replace(",", ".");
                    }
                    value = binding.parseValue(text, new DataValueRepository());
                }
                property.setValue(graph, value, binding);
            } else {
                property.setValue(graph, value);
            }
            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            graph.addMetadata((Metadata)cm.add("Set value " + ObjectUtils.toString((Object)value)));
        }
        catch (DataTypeSyntaxError e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (BindingException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static String queryDebugSupport(String query) {
        Session session = SimanticsInternal.getSession();
        DebugSupport ds = (DebugSupport)session.getService(DebugSupport.class);
        return (String)ds.query(session, "exec " + query);
    }

    public static String queryListSupport(String query) {
        Session session = SimanticsInternal.getSession();
        DebugSupport ds = (DebugSupport)session.getService(DebugSupport.class);
        return (String)ds.query(session, "list " + query);
    }

    public static void sort(ReadGraph graph, List<Resource> collection) {
        CollectionSupport cos = (CollectionSupport)graph.getService(CollectionSupport.class);
        cos.sort(collection);
    }

    public static List<Resource> sortByCluster(ReadGraph graph, Collection<Resource> collection) {
        CollectionSupport cos = (CollectionSupport)graph.getService(CollectionSupport.class);
        return cos.asSortedList(collection);
    }

    public static List<Object> sortByCluster(ReadGraph graph, List<Object> list, final Function1<Object, Resource> fn) {
        final ClusteringSupport cs = (ClusteringSupport)graph.getService(ClusteringSupport.class);
        ArrayList<Object> result = new ArrayList<Object>(list);
        Collections.sort(result, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                long l2;
                Resource r1 = (Resource)fn.apply(o1);
                Resource r2 = (Resource)fn.apply(o2);
                long l1 = cs.getCluster(r1);
                if (l1 < (l2 = cs.getCluster(r2))) {
                    return -1;
                }
                if (l1 > l2) {
                    return 1;
                }
                return 0;
            }
        });
        return result;
    }

    public static <T> List<T> sortByClusterT(ReadGraph graph, Collection<T> list, final Function1<T, Resource> fn) {
        final ClusteringSupport cs = (ClusteringSupport)graph.getService(ClusteringSupport.class);
        ArrayList<T> result = new ArrayList<T>(list);
        Collections.sort(result, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                long l2;
                Resource r1 = (Resource)fn.apply(o1);
                Resource r2 = (Resource)fn.apply(o2);
                long l1 = cs.getCluster(r1);
                if (l1 < (l2 = cs.getCluster(r2))) {
                    return -1;
                }
                if (l1 > l2) {
                    return 1;
                }
                return 0;
            }
        });
        return result;
    }

    public static void makeSynchronous(ReadGraph graph, boolean value) throws DatabaseException {
        graph.setSynchronous(value);
    }

    public static Set<Resource> listIndexRoots(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        TreeSet<Resource> indexRoots = new TreeSet<Resource>();
        indexRoots.addAll(Layer0Utils.listOntologies(graph));
        indexRoots.addAll((Collection)graph.syncRequest((Read)new ObjectsWithType(SimanticsInternal.getProject(), L0.ConsistsOf, L0.IndexRoot)));
        return indexRoots;
    }

    public static List<Resource> listOntologies(ReadGraph graph) throws DatabaseException {
        return (List)graph.syncRequest((Read)new OntologiesFromLibrary(graph.getRootLibrary()));
    }

    public static List<Resource> listGlobalOntologies(ReadGraph graph) throws DatabaseException {
        return (List)graph.syncRequest((Read)new GlobalOntologies(graph.getRootLibrary()));
    }

    public static <T> T applySCL(String module, String function, ReadGraph graph, Object ... args) throws DatabaseException {
        try {
            SCL_GRAPH.set(graph);
            Object t = ((Function)SCLOsgi.MODULE_REPOSITORY.getValue(String.valueOf(module) + "/" + function)).applyArray(args);
            SCL_GRAPH.set(null);
            return (T)t;
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
    }

    public static boolean isContainerPublished(ReadGraph graph, Variable variable) throws DatabaseException {
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleVariableIndexRoot(variable));
        if (indexRoot == null) {
            return false;
        }
        Resource represents = variable.getPossibleRepresents(graph);
        if (represents != null && represents.equals(indexRoot)) {
            return false;
        }
        return Layer0Utils.isPublished(graph, indexRoot);
    }

    public static boolean isContainerPublished(ReadGraph graph, Resource resource) throws DatabaseException {
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(resource));
        if (indexRoot == null) {
            return false;
        }
        if (resource.equals(indexRoot)) {
            return false;
        }
        return Layer0Utils.isPublished(graph, indexRoot);
    }

    public static boolean isPublished(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Boolean value = (Boolean)graph.getPossibleRelatedValue(resource, L0.Entity_published, (Binding)Bindings.BOOLEAN);
        if (value != null && value.booleanValue()) {
            return true;
        }
        Resource root = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(resource));
        return root != null && (value = (Boolean)graph.getPossibleRelatedValue(root, L0.Entity_published, (Binding)Bindings.BOOLEAN)) != null && value != false;
    }

    private static TransferableGraph1 makeTG(ReadGraph graph, Resource r) throws DatabaseException {
        SimanticsClipboardImpl cp = new SimanticsClipboardImpl();
        CopyHandler c1 = (CopyHandler)graph.adapt(r, CopyHandler.class);
        c1.copyToClipboard(graph, cp);
        Collection<Set<SimanticsClipboard.Representation>> reps = cp.getContents();
        if (reps.size() != 1) {
            return null;
        }
        return (TransferableGraph1)ClipboardUtils.accept(graph, reps.iterator().next(), SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
    }

    public static TransferableGraphSource makeTGSource(ReadGraph graph, Resource r) throws DatabaseException {
        SimanticsClipboardImpl cp = new SimanticsClipboardImpl();
        CopyHandler c1 = (CopyHandler)graph.adapt(r, CopyHandler.class);
        c1.copyToClipboard(graph, cp);
        Collection<Set<SimanticsClipboard.Representation>> reps = cp.getContents();
        if (reps.size() != 1) {
            return null;
        }
        return (TransferableGraphSource)ClipboardUtils.accept(graph, reps.iterator().next(), SimanticsKeys.KEY_TRANSFERABLE_GRAPH_SOURCE);
    }

    public static boolean merge(WriteGraph graph, Resource source, Resource target) throws DatabaseException {
        TransferableGraphSource tgs1 = Layer0Utils.makeTGSource((ReadGraph)graph, target);
        TransferableGraph1 tg1 = TransferableGraphs.create((ReadGraph)graph, (TransferableGraphSource)tgs1);
        TransferableGraph1 tg2 = Layer0Utils.makeTG((ReadGraph)graph, source);
        GraphRefactoringUtils.fixIncorrectRoot((Identity[])tg1.identities);
        GraphRefactoringUtils.fixIncorrectRoot((Identity[])tg2.identities);
        ModelTransferableGraphSource mtgs = (ModelTransferableGraphSource)tgs1;
        Diff diff = new Diff(tg1, tg2);
        TransferableGraphDelta1 delta = diff.diff();
        long[] oldResources = mtgs.getResourceArray((ReadGraph)graph);
        if (TransferableGraphs.hasChanges((ReadGraph)graph, (long[])oldResources, (TransferableGraphDelta1)delta)) {
            TransferableGraphs.applyDelta((WriteGraph)graph, (long[])mtgs.getResourceArray((ReadGraph)graph), (TransferableGraphDelta1)delta);
            return true;
        }
        return false;
    }

    public static Resource inferLiteralTypeFromString(ReadGraph graph, String text) {
        return Layer0.getInstance((ReadGraph)graph).String;
    }

    public static void emptyTrashBin() throws ServiceException {
        Layer0Utils.emptyTrashBin((IProgressMonitor)new NullProgressMonitor());
    }

    public static void emptyTrashBin(IProgressMonitor monitor) throws ServiceException {
        Layer0Utils.emptyTrashBin(monitor, SimanticsInternal.getSession(), SimanticsInternal.getProject());
    }

    public static void emptyTrashBin(IProgressMonitor monitor, Session session, final Resource project) throws ServiceException {
        final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Emptying Trash Bin...", (int)10000);
        try {
            final ArrayList unhandled = new ArrayList();
            session.syncRequest((DelayedWrite)new DelayedWriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    List<Resource> trashes;
                    Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, true);
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                    Resource parent = graph.getSingleObject(project, L0.PartOf);
                    Resource trashBin = Layer0Utils.getPossibleChild((ReadGraph)graph, parent, "TrashBin");
                    Collection<Object> collection = trashes = trashBin != null ? graph.getObjects(trashBin, L0.ConsistsOf) : Collections.emptyList();
                    if (trashes.isEmpty()) {
                        throw new CancelTransactionException();
                    }
                    mon.setWorkRemaining((2 + trashes.size()) * 1000);
                    for (Resource trash : trashes) {
                        if (mon.isCanceled()) {
                            throw new CancelTransactionException();
                        }
                        mon.subTask(NameUtils.getSafeName((ReadGraph)graph, (Resource)trash));
                        boolean isIndexRoot = graph.isInstanceOf(trash, L0.IndexRoot);
                        TGRemover remo = new TGRemover((IProgressMonitor)mon.newChild(1000, 7), trash);
                        try {
                            remo.remove(graph);
                            unhandled.addAll(remo.getRoots());
                        }
                        catch (DatabaseException databaseException) {
                            unhandled.add(trash);
                        }
                        if (!isIndexRoot) continue;
                        GenericRelationIndex index = (GenericRelationIndex)graph.adapt(L0X.DependenciesRelation, GenericRelationIndex.class);
                        IndexedRelations ir = (IndexedRelations)graph.getService(IndexedRelations.class);
                        ir.reset(null, (RequestProcessor)graph, L0X.DependenciesRelation, trash);
                        index.reset((RequestProcessor)graph, trash);
                    }
                    if (mon.isCanceled()) {
                        throw new CancelTransactionException();
                    }
                    mon.subTask("Committing Changes");
                    mon.newChild(1000);
                }
            });
            session.syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    for (Resource r : unhandled) {
                        EntityRemover.remove(graph, r);
                    }
                }
            });
            if (mon.isCanceled()) {
                return;
            }
            mon.subTask("Purging Database");
            mon.newChild(1000);
            Layer0Utils.purgeDatabase(monitor, session);
        }
        catch (CancelTransactionException cancelTransactionException) {
        }
        catch (DatabaseException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public static void purgeDatabase() throws ServiceException {
        Layer0Utils.purgeDatabase((IProgressMonitor)new NullProgressMonitor());
    }

    public static void purgeDatabase(IProgressMonitor monitor) throws ServiceException {
        Layer0Utils.purgeDatabase(monitor, SimanticsInternal.getSession());
    }

    public static void purgeDatabase(IProgressMonitor monitor, Session session) throws ServiceException {
        try {
            XSupport xs = (XSupport)session.getService(XSupport.class);
            xs.purge();
        }
        catch (DatabaseException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public static Resource getSingleDomainOf(ReadGraph graph, Resource type, Resource target) throws DatabaseException {
        Resource result = null;
        for (Resource candidate : Layer0Utils.getDomainOf(graph, type).values()) {
            if (!graph.isInstanceOf(candidate, target)) continue;
            if (result != null) {
                throw new DatabaseException("Multiple relations found for target " + graph.getURI(target) + " in type " + graph.getURI(type));
            }
            result = candidate;
        }
        if (result == null) {
            throw new DatabaseException("Multiple relations found for target " + graph.getURI(target) + " in type " + graph.getURI(type));
        }
        return result;
    }

    public static Map<String, Resource> getDomainOf(ReadGraph graph, Resource type) throws DatabaseException {
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        Map result = (Map)cs.createObjectResourceMap(String.class);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource r : graph.getObjects(type, L0.DomainOf)) {
            String name = (String)graph.getPossibleRelatedValue(r, L0.HasName, (Binding)Bindings.STRING);
            if (name == null) continue;
            result.put(name, r);
        }
        for (Resource t : graph.getSupertypes(type)) {
            for (Resource r : graph.getObjects(t, L0.DomainOf)) {
                String name = (String)graph.getPossibleRelatedValue(r, L0.HasName, (Binding)Bindings.STRING);
                if (name == null) continue;
                result.put(name, r);
            }
        }
        return result;
    }

    public static Resource getPossiblePredicateByNameFromType(ReadGraph graph, Resource type, String name) throws DatabaseException {
        Map<String, Resource> domain = Layer0Utils.getDomainOf(graph, type);
        return domain.get(name);
    }

    public static Resource getPossiblePredicateByName(ReadGraph graph, Resource instance, String predicateName) throws DatabaseException {
        for (Resource type : graph.getPrincipalTypes(instance)) {
            Map<String, Resource> domainOf = Layer0Utils.getDomainOf(graph, type);
            Resource predicate = domainOf.get(predicateName);
            if (predicate == null) continue;
            return predicate;
        }
        return null;
    }

    public static Resource getPossiblePredicateByLabel(ReadGraph graph, Resource instance, String predicateName) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource type : graph.getPrincipalTypes(instance)) {
            Map<String, Resource> domainOf = Layer0Utils.getDomainOf(graph, type);
            for (Resource r : domainOf.values()) {
                String label = (String)graph.getPossibleRelatedValue(r, L0.HasLabel, (Binding)Bindings.STRING);
                if (!predicateName.equals(label)) continue;
                return r;
            }
        }
        return null;
    }

    public static void claimLiteralDataboard(WriteGraph graph, Resource container, Resource property, String valueText) throws DatabaseException {
        try {
            PropertyInfo pi = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(property));
            if (pi.literalRange == null) {
                throw new DatabaseException("No suitable literal type defined as range for property.");
            }
            if (pi.defaultBinding == null) {
                throw new DatabaseException("No suitable default binding for property.");
            }
            Object value = pi.defaultBinding.parseValue(valueText, new DataValueRepository());
            graph.claimLiteral(container, property, pi.literalRange, value, pi.defaultBinding);
        }
        catch (DataTypeSyntaxError e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (BindingException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static String prettyPrintResource(ReadGraph graph, Resource resource, boolean ignoreIdentifiers) throws Exception {
        TransferableGraphSource source = Layer0Utils.makeTGSource(graph, resource);
        TransferableGraph1 tg = TransferableGraphs.create((ReadGraph)graph, (TransferableGraphSource)source);
        GraphRefactoringUtils.fixOntologyExport((TransferableGraph1)tg);
        System.out.println("Printing resoure " + graph.getURI(resource));
        return PrettyPrintTG.print((TransferableGraph1)tg, (boolean)ignoreIdentifiers);
    }

    public static void claimNewIdentifier(WriteGraph graph, Resource component, boolean add) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        GUID guid = GUID.random();
        if (add) {
            graph.addLiteral(component, L0.identifier, L0.identifier_Inverse, L0.GUID, (Object)guid, GUID.BINDING);
        } else {
            graph.claimLiteral(component, L0.identifier, L0.identifier_Inverse, L0.GUID, (Object)guid, GUID.BINDING);
        }
    }

    public static boolean renewIdentifier(WriteGraph graph, Resource entity) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Statement stm = graph.getPossibleStatement(entity, L0.identifier);
        if (stm != null) {
            graph.claimValue(stm.getObject(), (Object)GUID.random(), GUID.BINDING);
            return true;
        }
        return false;
    }

    public static void addMetadataListener(ChangeListener listener) {
        ((GraphChangeListenerSupport)SimanticsInternal.getSession().getService(GraphChangeListenerSupport.class)).addMetadataListener(listener);
    }

    public static void removeMetadataListener(ChangeListener listener) {
        ((GraphChangeListenerSupport)SimanticsInternal.getSession().getService(GraphChangeListenerSupport.class)).removeMetadataListener(listener);
    }
}

