/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.indexing;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Tuukka Lehtonen
 * @author Antti Villberg
 */
public class ImmutableIndexedRelationsSearcher extends IndexedRelationsSearcherBase {

	ImmutableIndexedRelationsSearcher(RequestProcessor session, Resource relation, Resource input) {
		super(session, relation, input);
	}

	@Override
	String getDescriptor() {
		return "IMMU:";
	}
	
    @Override
    Throwable bestEffortClear(IProgressMonitor monitor, Session session) {
    	return new IllegalStateException("Immutable index cannot be cleared");
    }

    @Override
    protected Logger getLogger() {
        return LoggerFactory.getLogger(ImmutableIndexedRelationsSearcher.class);
    }
	
}
