/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.function.TObjectFunction;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.io.Externalizable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.simantics.db.impl.query.CacheCollectionResult;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.StableObjectHash;

public class StableHashMap<K, V>
extends StableObjectHash<K>
implements Map<K, V>,
Externalizable {
    static final long serialVersionUID = 1L;
    protected transient V[] _values;

    @Override
    public StableHashMap<K, V> clone() {
        StableHashMap m = (StableHashMap)super.clone();
        m._values = (Object[])this._values.clone();
        return m;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        return capacity;
    }

    @Override
    public V put(K key, V value) {
        int index = this.insertionIndex(key);
        return this.doPut(key, value, index);
    }

    public V put(K key, V value, int hash) {
        int index = this.insertionIndex(key, hash);
        return this.doPut(key, value, index);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        int index = this.insertionIndex(key);
        if (index < 0) {
            return this._values[-index - 1];
        }
        return this.doPut(key, value, index);
    }

    private V doPut(K key, V value, int index) {
        V previous = null;
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        Object oldKey = this._set[index];
        this._set[index] = key;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(oldKey == FREE);
        }
        return previous;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Map)) {
            return false;
        }
        Map that = (Map)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    @Override
    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    public String toString() {
        final StringBuilder buf = new StringBuilder("{");
        this.forEachEntry(new TObjectObjectProcedure<K, V>(){
            private boolean first = true;

            public boolean execute(K key, V value) {
                if (this.first) {
                    this.first = false;
                } else {
                    buf.append(",");
                }
                buf.append(key);
                buf.append("=");
                buf.append(value);
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    public boolean forEachKey(TObjectProcedure<K> procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TObjectProcedure<V> procedure) {
        V[] values = this._values;
        Object[] set = this._set;
        int i = values.length;
        while (i-- > 0) {
            if (set[i] == FREE || set[i] == REMOVED || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectObjectProcedure<K, V> procedure) {
        Object[] keys = this._set;
        V[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TObjectObjectProcedure<K, V> procedure) {
        boolean modified = false;
        Object[] keys = this._set;
        V[] values = this._values;
        this.tempDisableAutoCompaction();
        try {
            int i = keys.length;
            while (i-- > 0) {
                if (keys[i] == FREE || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return modified;
    }

    public void transformValues(TObjectFunction<V, V> function) {
        V[] values = this._values;
        Object[] set = this._set;
        int i = values.length;
        while (i-- > 0) {
            if (set[i] == FREE || set[i] == REMOVED) continue;
            values[i] = function.execute(values[i]);
        }
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldKeys = this._set;
        V[] oldVals = this._values;
        this._set = new Object[newCapacity];
        Arrays.fill(this._set, FREE);
        this._values = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == FREE || oldKeys[i] == REMOVED) continue;
            Object o = oldKeys[i];
            int index = this.insertionIndex(o);
            if (index < 0) {
                this.throwObjectContractViolation(this._set[-index - 1], o);
            }
            this._set[index] = o;
            this._values[index] = oldVals[i];
        }
    }

    @Override
    public V get(Object key) {
        Object[] set = this._set;
        V[] values = this._values;
        int index = this.index(key, set);
        return index < 0 ? null : (V)values[index];
    }

    public V get(Object key, int hash) {
        Object[] set = this._set;
        V[] values = this._values;
        int index = this.index(key, hash, set);
        return index < 0 ? null : (V)values[index];
    }

    @Override
    public void clear() {
        if (this.size() == 0) {
            return;
        }
        super.clear();
        Arrays.fill(this._set, 0, this._set.length, FREE);
        Arrays.fill(this._values, 0, this._values.length, null);
    }

    @Override
    public V remove(Object key) {
        Object[] set = this._set;
        V[] values = this._values;
        V prev = null;
        int index = this.index(key, set);
        if (index >= 0) {
            prev = values[index];
            this.removeAt(index);
        }
        return prev;
    }

    @Override
    protected void removeAt(int index) {
        this._values[index] = null;
        super.removeAt(index);
    }

    protected void removeAt(int index, V[] values) {
        values[index] = null;
        super.removeAt(index);
    }

    public void values(int level, CacheCollectionResult result) {
        int i = this._set.length;
        while (i-- > 0) {
            CacheEntryBase e;
            if (this._set[i] == null || this._set[i] == REMOVED || this._set[i] == FREE || (e = (CacheEntryBase)this._values[i]).getLevel() > level) continue;
            result.add(e);
        }
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>();
        int i = this._set.length;
        while (i-- > 0) {
            if (this._set[i] == null || this._set[i] == REMOVED || this._set[i] == FREE) continue;
            result.add(this._values[i]);
        }
        return result;
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object val) {
        Object[] set = this._set;
        V[] vals = this._values;
        if (val == null) {
            int i = vals.length;
            while (i-- > 0) {
                if (set[i] == FREE || set[i] == REMOVED || val != vals[i]) continue;
                return true;
            }
        } else {
            int i = vals.length;
            while (i-- > 0) {
                if (set[i] == FREE || set[i] == REMOVED || val != vals[i] && !val.equals(vals[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.contains(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.ensureCapacity(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    private static final class EqProcedure<K, V>
    implements TObjectObjectProcedure<K, V> {
        private final Map<K, V> _otherMap;

        EqProcedure(Map<K, V> otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(K key, V value) {
            if (value == null && !this._otherMap.containsKey(key)) {
                return false;
            }
            V oValue = this._otherMap.get(key);
            return oValue == value || oValue != null && oValue.equals(value);
        }
    }

    private final class HashProcedure
    implements TObjectObjectProcedure<K, V> {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(K key, V value) {
            this.h += StableHashMap.this._hashingStrategy.computeHashCode(key) ^ (value == null ? 0 : value.hashCode());
            return true;
        }
    }
}

