/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.concurrent.Semaphore;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.IntProcedureAdapter;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CollectionUnaryQuery;
import org.simantics.db.impl.query.IntArray;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.query.UnaryQuery;
import org.simantics.db.procedure.ListenerBase;

public final class OrderedSet
extends CollectionUnaryQuery<IntProcedure> {
    private int current = 0;

    public OrderedSet(int r) {
        super(r);
    }

    static final OrderedSet entry(QueryProcessor provider, int r) {
        return (OrderedSet)provider.orderedSetMap.get(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void runner(ReadGraphImpl graph, int r, QueryProcessor provider, OrderedSet cached, CacheEntry parent, ListenerBase listener, IntProcedure procedure) {
        OrderedSet entry;
        OrderedSet orderedSet = entry = cached != null ? cached : (OrderedSet)provider.orderedSetMap.get(r);
        if (entry == null) {
            entry = new OrderedSet(r);
            entry.setPending();
            entry.clearResult(provider.querySupport);
            entry.putEntry(provider);
            provider.performForEach(graph, entry, parent, listener, procedure);
        } else {
            if (entry.isPending()) {
                OrderedSet orderedSet2 = entry;
                synchronized (orderedSet2) {
                    if (entry.isPending()) {
                        throw new IllegalStateException();
                    }
                }
            }
            provider.performForEach(graph, entry, parent, listener, procedure);
        }
    }

    public static final void queryEach(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent, ListenerBase listener, IntProcedure procedure) {
        assert (r != 0);
        OrderedSet entry = (OrderedSet)provider.orderedSetMap.get(r);
        if (parent == null && listener == null && entry != null && entry.isReady()) {
            entry.performFromCache(graph, provider, procedure);
            return;
        }
        OrderedSet.runner(graph, r, provider, entry, parent, listener, procedure);
    }

    @Override
    public UnaryQuery<IntProcedure> getEntry(QueryProcessor provider) {
        return provider.orderedSetMap.get(this.id);
    }

    @Override
    public void putEntry(QueryProcessor provider) {
        provider.orderedSetMap.put(this.id, this);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.orderedSetMap.remove(this.id);
    }

    private boolean nextElement(ReadGraphImpl graph, QueryProcessor provider, final IntProcedure procedure, boolean store) {
        provider.querySupport.ensureLoaded(graph, this.current);
        boolean found = provider.querySupport.getObjects(graph, this.current, this.id, new IntProcedure(){

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                if (i != OrderedSet.this.id) {
                    OrderedSet.this.addOrSet(i);
                    procedure.execute(graph, i);
                }
                OrderedSet.this.current = i;
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                procedure.exception(graph, t);
            }

            @Override
            public void finished(ReadGraphImpl graph) {
            }
        });
        if (!found) {
            this.current = this.id;
        }
        if (this.current == this.id) {
            this.finish(graph, provider);
            procedure.finished(graph);
            return false;
        }
        return true;
    }

    @Override
    public void clearResult(QuerySupport support) {
        this.current = this.id;
        this.setResult(new IntArray());
    }

    @Override
    public Object computeForEach(ReadGraphImpl graph, QueryProcessor provider, IntProcedure procedure, boolean store) {
        while (this.nextElement(graph, provider, procedure, store)) {
        }
        return this.getResult();
    }

    public String toString() {
        return "OrderedSet[" + this.id + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void finish(ReadGraphImpl graph, QueryProcessor provider) {
        assert (this.isPending());
        OrderedSet orderedSet = this;
        synchronized (orderedSet) {
            this.setReady();
        }
    }

    public final void addOrSet(int add) {
        assert (this.isPending());
        IntArray value = (IntArray)this.getResult();
        value.add(add);
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, QueryProcessor provider, IntProcedure procedure) {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return EXCEPTED;
        }
        IntArray value = (IntArray)this.getResult();
        if (value.data == null) {
            if (value.sizeOrData != -1) {
                procedure.execute(graph, value.sizeOrData);
            }
        } else {
            int i = 0;
            while (i < value.sizeOrData) {
                procedure.execute(graph, value.data[i]);
                ++i;
            }
        }
        procedure.finished(graph);
        return value;
    }

    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        final Semaphore s = new Semaphore(0);
        this.computeForEach(graph, provider, new IntProcedureAdapter(){

            @Override
            public void finished(ReadGraphImpl graph) {
                s.release();
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                throw new Error("Error in recompute.", t);
            }
        }, true);
        while (!s.tryAcquire()) {
            provider.resume(graph);
        }
    }
}

