/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.Collection;
import java.util.concurrent.Semaphore;
import org.simantics.db.RelationInfo;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.IntProcedureAdapter;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.AssertedStatements;
import org.simantics.db.impl.query.BinaryQuery;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CollectionBinaryQuery;
import org.simantics.db.impl.query.DirectObjects;
import org.simantics.db.impl.query.DirectPredicates;
import org.simantics.db.impl.query.IntArray;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.PrincipalTypes;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.RelationInfoQuery;
import org.simantics.db.impl.query.SuperRelations;
import org.simantics.db.impl.query.SuperTypes;
import org.simantics.db.impl.query.SyncIntProcedure;
import org.simantics.db.impl.query.TripleIntProcedure;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.ListenerBase;

public final class Objects
extends CollectionBinaryQuery<IntProcedure> {
    static final Runner2Procedure runner2Procedure = new Runner2Procedure();
    static final InternalProcedure<IntSet> NOP = new InternalProcedure<IntSet>(){

        @Override
        public void execute(ReadGraphImpl graph, IntSet result) {
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }
    };
    static final TripleIntProcedure NOPT = new TripleIntProcedure(){

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }

        @Override
        public void execute(ReadGraphImpl graph, int s, int p, int o) {
        }

        @Override
        public void finished(ReadGraphImpl graph) {
        }
    };
    static final InternalProcedure<RelationInfo> ip = new InternalProcedure<RelationInfo>(){

        @Override
        public void execute(ReadGraphImpl graph, RelationInfo result) {
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }
    };

    public Objects(int r1, int r2) {
        super(r1, r2);
    }

    static final Objects entry(QueryProcessor provider, int r1, int r2) {
        return (Objects)provider.objectsMap.get(r1, r2);
    }

    static final Collection<Objects> entries(QueryProcessor processor, int r1) {
        return processor.objectsMap.values(r1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void runner(ReadGraphImpl graph, int r1, int r2, CacheEntry parent, ListenerBase listener, IntProcedure procedure) {
        if (parent == null && listener == null) {
            Objects.computeForEach(graph, r1, r2, null, procedure);
            return;
        }
        QueryProcessor processor = graph.processor;
        Objects entry = (Objects)processor.objectsMap.get(r1, r2);
        if (entry == null) {
            entry = new Objects(r1, r2);
            entry.setPending();
            entry.clearResult(processor.querySupport);
            entry.putEntry(processor);
            processor.performForEach(graph, entry, parent, listener, procedure);
        } else {
            if (entry.isPending()) {
                Objects objects = entry;
                synchronized (objects) {
                    if (entry.isPending()) {
                        processor.registerDependencies(graph, entry, parent, listener, procedure, false);
                        Objects.computeForEach(graph, r1, r2, null, procedure);
                        return;
                    }
                }
            }
            processor.performForEach(graph, entry, parent, listener, procedure);
        }
    }

    public static final int runner2(ReadGraphImpl graph, int r1, int r2, CacheEntry parent) throws DatabaseException {
        runner2Procedure.clear();
        if (parent == null) {
            Objects.computeForEach(graph, r1, r2, null, runner2Procedure);
            return runner2Procedure.get();
        }
        QueryProcessor processor = graph.processor;
        Objects entry = (Objects)processor.objectsMap.get(r1, r2);
        if (entry == null) {
            entry = new Objects(r1, r2);
            entry.setPending();
            entry.clearResult(processor.querySupport);
            entry.putEntry(processor);
            processor.performForEach(graph, entry, parent, null, runner2Procedure);
            return runner2Procedure.get();
        }
        if (entry.isPending()) {
            throw new IllegalStateException();
        }
        processor.performForEach(graph, entry, parent, null, runner2Procedure);
        return runner2Procedure.get();
    }

    @Override
    public BinaryQuery<IntProcedure> getEntry(QueryProcessor provider) {
        return provider.objectsMap.get(this.id);
    }

    @Override
    public void putEntry(QueryProcessor provider) {
        provider.objectsMap.put(this.id, this);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.objectsMap.remove(this.id);
    }

    private static final IntArray getAssertionMap(ReadGraphImpl graph, int r1, int r2, Objects entry) {
        class AssertionMapProc
        implements IntProcedure {
            boolean first = true;
            private IntArray result;
            private final /* synthetic */ int val$r2;
            private final /* synthetic */ Objects val$entry;

            AssertionMapProc(int n, Objects objects) {
                this.val$r2 = n;
                this.val$entry = objects;
            }

            public void addStatement(int s, int p, int o) {
                if (this.result.size() == 0) {
                    this.result.add(s);
                    this.result.add(p);
                    this.result.add(o);
                } else {
                    int i = 0;
                    while (i < this.result.sizeOrData) {
                        int existingO;
                        int existingP = this.result.data[i + 1];
                        if (p == existingP && (existingO = this.result.data[i + 2]) == o) {
                            return;
                        }
                        i += 3;
                    }
                    this.result.add(s);
                    this.result.add(p);
                    this.result.add(o);
                }
            }

            @Override
            public void execute(ReadGraphImpl graph, int type) {
                AssertedStatements stms = AssertedStatements.queryEach(graph, type, this.val$r2, graph.processor, this.val$entry, null, NOPT);
                if (this.result == null) {
                    this.result = (IntArray)stms.getResult();
                } else {
                    int i;
                    IntArray ia;
                    if (this.first) {
                        ia = this.result;
                        this.result = new IntArray();
                        if (ia.data != null) {
                            i = 0;
                            while (i < ia.sizeOrData) {
                                this.addStatement(ia.data[i], ia.data[i + 1], ia.data[i + 2]);
                                i += 3;
                            }
                        }
                        this.first = false;
                    }
                    ia = (IntArray)stms.getResult();
                    if (ia.data != null) {
                        i = 0;
                        while (i < ia.sizeOrData) {
                            this.addStatement(ia.data[i], ia.data[i + 1], ia.data[i + 2]);
                            i += 3;
                        }
                    }
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable throwable) {
            }
        }
        AssertionMapProc amp = new AssertionMapProc(r2, entry);
        PrincipalTypes.queryEach(graph, r1, graph.processor, entry, null, amp);
        return amp.result;
    }

    private static final void forSingleAssertion(ReadGraphImpl graph, int r1, int r2, Objects entry, IntProcedure procedure) {
        IntArray map = Objects.getAssertionMap(graph, r1, r2, entry);
        if (map == null) {
            if (entry != null) {
                entry.finish(graph, procedure);
            } else {
                procedure.finished(graph);
            }
            return;
        }
        int size = map.size();
        if (size == 3) {
            int value = map.data[2];
            if (entry != null) {
                entry.addOrSetFunctional(value);
                entry.finish(graph, procedure);
            } else {
                procedure.execute(graph, value);
                procedure.finished(graph);
            }
        } else if (size == 0) {
            if (entry != null) {
                entry.finish(graph, procedure);
            } else {
                procedure.finished(graph);
            }
        } else {
            int candidateS = map.data[0];
            int candidateO = map.data[2];
            SuperTypes candidate = SuperTypes.queryEach(graph, candidateS, graph.processor, entry, null, NOP);
            if (candidate.isExcepted()) {
                if (entry != null) {
                    entry.except((Throwable)candidate.getResult());
                }
                procedure.exception(graph, (Throwable)candidate.getResult());
                return;
            }
            IntSet candidateIs = (IntSet)candidate.getResult();
            int i = 3;
            while (i < map.size()) {
                int nextS = map.data[i];
                int nextO = map.data[i + 2];
                if (nextS != candidateS && !candidateIs.contains(nextS)) {
                    SuperTypes next = SuperTypes.queryEach(graph, nextS, graph.processor, entry, null, NOP);
                    if (next.isExcepted()) {
                        if (entry != null) {
                            entry.except((Throwable)next.getResult());
                        }
                        procedure.exception(graph, (Throwable)next.getResult());
                        return;
                    }
                    IntSet nextIs = (IntSet)next.getResult();
                    if (nextIs.contains(candidateS)) {
                        candidateS = nextS;
                        candidateO = nextO;
                        candidateIs = nextIs;
                    } else {
                        ManyObjectsForFunctionalRelationException exception = new ManyObjectsForFunctionalRelationException("Functional relation has conflicting assertions " + r1 + ", " + r2 + " " + map, r1);
                        if (entry != null) {
                            entry.except(exception);
                        }
                        procedure.exception(graph, exception);
                        return;
                    }
                }
                i += 3;
            }
            if (entry != null) {
                entry.addOrSetFunctional(candidateO);
                entry.finish(graph, procedure);
            } else {
                procedure.execute(graph, candidateO);
                procedure.finished(graph);
            }
        }
    }

    public final void computeFunctionalIndex(ReadGraphImpl graph, QueryProcessor provider, RelationInfo ri, IntProcedure procedure) {
        Objects.computeFunctionalIndex(graph, this.r1(), this.r2(), this, ri, procedure);
    }

    public static final void computeFunctionalIndex(ReadGraphImpl graph, final int r1, final int r2, final Objects entry, RelationInfo ri, final IntProcedure procedure) {
        if (ri.isFinal) {
            int result = graph.processor.querySupport.getFunctionalObject(r1, r2);
            if (result == 0) {
                Objects.forSingleAssertion(graph, r1, r2, entry, procedure);
            } else if (result == -1) {
                graph.processor.querySupport.getObjects(graph, r1, r2, new IntProcedure(){

                    @Override
                    public void execute(ReadGraphImpl graph, int i) {
                        if (entry != null) {
                            entry.addOrSetFunctional(i);
                        } else {
                            procedure.execute(graph, i);
                        }
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) {
                    }
                });
                Objects.forSingleAssertion(graph, r1, r2, entry, procedure);
            } else if (entry != null) {
                entry.addOrSetFunctional(result);
                entry.finish(graph, procedure);
            } else {
                procedure.execute(graph, result);
                procedure.finished(graph);
            }
        } else {
            DirectPredicates.queryEach(graph, r1, graph.processor, null, null, new SyncIntProcedure(){
                boolean found = false;

                @Override
                public void run(ReadGraphImpl graph) {
                    if (this.found) {
                        if (entry != null) {
                            entry.finish(graph, procedure);
                        } else {
                            procedure.finished(graph);
                        }
                    } else {
                        Objects.forSingleAssertion(graph, r1, r2, entry, procedure);
                    }
                }

                @Override
                public void execute(ReadGraphImpl graph, final int pred) {
                    if (this.found) {
                        return;
                    }
                    if (pred == r2) {
                        DirectObjects.queryEach(graph, r1, pred, graph.processor, null, null, new IntProcedure(){

                            @Override
                            public void execute(ReadGraphImpl graph, int i) {
                                if (!found) {
                                    if (entry != null) {
                                        entry.addOrSetFunctional(i);
                                    } else {
                                        procedure.execute(graph, i);
                                    }
                                    found = true;
                                } else {
                                    ManyObjectsForFunctionalRelationException exception = new ManyObjectsForFunctionalRelationException("Functional relation has more than one statement (r1=" + r1 + ", r2=" + r2 + ").", r1);
                                    if (entry != null) {
                                        entry.except(exception);
                                    }
                                    procedure.exception(graph, exception);
                                }
                            }

                            @Override
                            public void finished(ReadGraphImpl graph) {
                            }

                            @Override
                            public void exception(ReadGraphImpl graph, Throwable t) {
                                procedure.exception(graph, t);
                            }
                        });
                    } else {
                        SuperRelations.queryEach(graph, pred, graph.processor, entry, null, new InternalProcedure<IntSet>(){

                            @Override
                            public void execute(ReadGraphImpl graph, IntSet result) {
                                if (found) {
                                    return;
                                }
                                if (result.contains(r2)) {
                                    DirectObjects.queryEach(graph, r1, pred, graph.processor, null, null, new IntProcedure(){

                                        @Override
                                        public void execute(ReadGraphImpl graph, int i) {
                                            if (!found) {
                                                if (entry != null) {
                                                    entry.addOrSetFunctional(i);
                                                } else {
                                                    procedure.execute(graph, i);
                                                }
                                                found = true;
                                            } else {
                                                ManyObjectsForFunctionalRelationException exception = new ManyObjectsForFunctionalRelationException("Functional relation has more than one statement (r1=" + r1 + ", r2=" + r2 + ").", r1);
                                                if (entry != null) {
                                                    entry.except(exception);
                                                }
                                                procedure.exception(graph, exception);
                                            }
                                        }

                                        @Override
                                        public void finished(ReadGraphImpl graph) {
                                        }

                                        @Override
                                        public void exception(ReadGraphImpl graph, Throwable t) {
                                            procedure.exception(graph, t);
                                        }
                                    });
                                }
                            }

                            @Override
                            public void exception(ReadGraphImpl graph, Throwable t) {
                                procedure.exception(graph, t);
                            }
                        });
                    }
                }

                @Override
                public void finished(ReadGraphImpl graph) {
                    this.dec(graph);
                }
            });
        }
    }

    private static final void forAssertions(ReadGraphImpl graph, int r1, final int r2, final Objects entry, final IntProcedure procedure) {
        PrincipalTypes.queryEach(graph, r1, graph.processor, null, null, new SyncIntProcedure(){
            TripleIntProcedure proc;
            {
                this.proc = new TripleIntProcedure(){

                    @Override
                    public void execute(ReadGraphImpl graph, int s, int p, int o) {
                        if (objects != null) {
                            objects.addOrSet(o);
                        } else {
                            intProcedure.execute(graph, o);
                        }
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) {
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                        intProcedure.exception(graph, t);
                        this.dec(graph);
                    }
                };
            }

            @Override
            public void run(ReadGraphImpl graph) {
                if (entry != null) {
                    entry.finish(graph, procedure);
                } else {
                    procedure.finished(graph);
                }
            }

            @Override
            public void execute(ReadGraphImpl graph, int type) {
                this.inc();
                AssertedStatements.queryEach(graph, type, r2, graph.processor, entry, null, this.proc);
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                this.dec(graph);
            }
        });
    }

    public static final void computeNotFunctionalFinalIndex(ReadGraphImpl graph, int r1, int r2, QueryProcessor provider, RelationInfo ri, AsyncMultiProcedure<Resource> procedure) {
        throw new Error();
    }

    public final void computeNotFunctionalIndex(ReadGraphImpl graph, RelationInfo ri, IntProcedure procedure) {
        Objects.computeNotFunctionalIndex(graph, this.r1(), this.r2(), this, ri, procedure);
    }

    public static final void computeNotFunctionalIndex(ReadGraphImpl graph, final int r1, final int r2, final Objects entry, RelationInfo ri, final IntProcedure procedure) {
        if (ri.isFinal) {
            graph.processor.querySupport.getObjects(graph, r1, r2, new IntProcedure(){

                @Override
                public void execute(ReadGraphImpl graph, int i) {
                    if (entry != null) {
                        entry.addOrSet(i);
                    } else {
                        procedure.execute(graph, i);
                    }
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    procedure.exception(graph, t);
                }

                @Override
                public void finished(ReadGraphImpl graph) {
                }
            });
            if (ri.isAsserted) {
                Objects.forAssertions(graph, r1, r2, entry, procedure);
            } else if (entry != null) {
                entry.finish(graph, procedure);
            } else {
                procedure.finished(graph);
            }
        } else {
            DirectPredicates.queryEach(graph, r1, graph.processor, null, null, new SyncIntProcedure(){

                @Override
                public void run(ReadGraphImpl graph) {
                    Objects.forAssertions(graph, r1, r2, entry, procedure);
                }

                @Override
                public void execute(ReadGraphImpl graph, final int pred) {
                    if (pred == r2) {
                        this.inc();
                        DirectObjects.queryEach(graph, r1, pred, graph.processor, null, null, new IntProcedure(){

                            @Override
                            public void execute(ReadGraphImpl graph, int i) {
                                if (entry != null) {
                                    entry.addOrSet(i);
                                } else {
                                    procedure.execute(graph, i);
                                }
                            }

                            @Override
                            public void finished(ReadGraphImpl graph) {
                                this.dec(graph);
                            }

                            @Override
                            public void exception(ReadGraphImpl graph, Throwable t) {
                                procedure.exception(graph, t);
                                this.dec(graph);
                            }
                        });
                    } else {
                        this.inc();
                        SuperRelations.queryEach(graph, pred, graph.processor, entry, null, new InternalProcedure<IntSet>(){

                            @Override
                            public void execute(ReadGraphImpl graph, IntSet result) {
                                if (result.contains(r2)) {
                                    this.inc();
                                    DirectObjects.queryEach(graph, r1, pred, graph.processor, null, null, new IntProcedure(){

                                        @Override
                                        public void execute(ReadGraphImpl graph, int i) {
                                            if (entry != null) {
                                                entry.addOrSet(i);
                                            } else {
                                                procedure.execute(graph, i);
                                            }
                                        }

                                        @Override
                                        public void finished(ReadGraphImpl graph) {
                                            this.dec(graph);
                                        }

                                        @Override
                                        public void exception(ReadGraphImpl graph, Throwable t) {
                                            procedure.exception(graph, t);
                                            this.dec(graph);
                                        }
                                    });
                                }
                                this.dec(graph);
                            }

                            @Override
                            public void exception(ReadGraphImpl graph, Throwable t) {
                                procedure.exception(graph, t);
                                this.dec(graph);
                            }
                        });
                    }
                }

                @Override
                public void finished(ReadGraphImpl graph) {
                    this.dec(graph);
                }
            });
        }
    }

    @Override
    public void computeForEach(ReadGraphImpl graph, QueryProcessor provider, IntProcedure procedure, boolean store) {
        Objects.computeForEach(graph, this.r1(), this.r2(), this, procedure);
    }

    public static void computeForEach(ReadGraphImpl graph, int r1, int r2, Objects entry, IntProcedure procedure) {
        RelationInfo ri = RelationInfoQuery.queryEach(graph, r2, graph.processor, entry, null, ip);
        graph.ensureLoaded(r1, r2);
        if (ri.isFunctional) {
            Objects.computeFunctionalIndex(graph, r1, r2, entry, ri, procedure);
        } else {
            Objects.computeNotFunctionalIndex(graph, r1, r2, entry, ri, procedure);
        }
    }

    public String toString() {
        return "Objects[" + this.r1() + " - " + this.r2() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void finish(ReadGraphImpl graph, IntProcedure procedure) {
        assert (this.assertPending());
        Objects objects = this;
        synchronized (objects) {
            this.setReady();
        }
        IntArray v = (IntArray)this.getResult();
        if (v.data == null) {
            if (v.sizeOrData != -1) {
                procedure.execute(graph, v.sizeOrData);
            }
        } else {
            int i = 0;
            while (i < v.sizeOrData) {
                procedure.execute(graph, v.data[i]);
                ++i;
            }
        }
        procedure.finished(graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addOrSet(int add) {
        IntArray value;
        assert (this.assertPending());
        IntArray intArray = value = (IntArray)this.getResult();
        synchronized (intArray) {
            value.add(add);
        }
    }

    public final void addOrSetFunctional(int add) {
        assert (this.isPending());
        IntArray value = (IntArray)this.getResult();
        value.add(add);
    }

    @Override
    public void performFromCache(ReadGraphImpl graph, QueryProcessor provider, IntProcedure procedure) {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return;
        }
        IntArray value = (IntArray)this.getResult();
        if (value.data == null) {
            if (value.sizeOrData != -1) {
                procedure.execute(graph, value.sizeOrData);
            }
        } else {
            int i = 0;
            while (i < value.sizeOrData) {
                procedure.execute(graph, value.data[i]);
                ++i;
            }
        }
        procedure.finished(graph);
    }

    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        final Semaphore s = new Semaphore(0);
        this.computeForEach(graph, provider, new IntProcedureAdapter(){

            @Override
            public void finished(ReadGraphImpl graph) {
                s.release();
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                s.release();
                new Error("Error in recompute.", t).printStackTrace();
            }
        }, true);
        while (!s.tryAcquire()) {
            provider.resume(graph);
        }
    }

    @Override
    public int type() {
        return 1;
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutable(this.r1());
    }

    static class Runner2Procedure
    implements IntProcedure {
        public int single = 0;
        public Throwable t = null;

        Runner2Procedure() {
        }

        public void clear() {
            this.single = 0;
            this.t = null;
        }

        @Override
        public void execute(ReadGraphImpl graph, int i) {
            this.single = this.single == 0 ? i : -1;
        }

        @Override
        public void finished(ReadGraphImpl graph) {
            if (this.single == -1) {
                this.single = 0;
            }
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
            this.single = 0;
            this.t = throwable;
        }

        public int get() throws DatabaseException {
            if (this.t != null) {
                if (this.t instanceof DatabaseException) {
                    throw (DatabaseException)this.t;
                }
                throw new DatabaseException(this.t);
            }
            return this.single;
        }
    }
}

