/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;

import org.simantics.db.Resource;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.ListenerBase;

final public class PossibleSuperRelation extends UnaryQuery<IntProcedure> {

	private PossibleSuperRelation(final int resource) {
		super(resource);
	}

	final public static void queryEach(ReadGraphImpl graph, final int r, final QueryProcessor provider, final CacheEntry parent, final ListenerBase listener, final AsyncProcedure<Resource> procedure) {

		int result = provider.querySupport.getSingleSuperrelation(r);
		if(result != 0) {
			procedure.execute(graph, provider.querySupport.getResource(result));
		} else {
			procedure.execute(graph, null);
		}

	}

	@Override
	public UnaryQuery<IntProcedure> getEntry(QueryProcessor provider) {
		return null;
	}

	@Override
	public void putEntry(QueryProcessor provider) {
	}

	@Override
	final public void removeEntry(QueryProcessor provider) {
	}

	class Koss {

		private TIntHashSet set = null;
		public int single = 0;

		public boolean add(int val) {
			if(single == val) return false;
			if(single == 0) {
				single = val;
				return true;
			}
			if(set == null) set = new TIntHashSet(4);
			return set.add(val);
		}

		public int size() {

			if(single == 0) return 0;
			if(set == null) return 1;
			return set.size() + 1;

		}

		//        public int[] toArray() {
			//            
			//            int[] result = Arrays.copyOf(set.toArray(), set.size() + 1);
			//            result[set.size()] = single;
			//            return result;
			//            
			//        }
		//        

		public void forEach(TIntProcedure proc) {
			if(single > 0) proc.execute(single);
			if(set != null) set.forEach(proc);
		}

	}

	@Override
	public Object computeForEach(final ReadGraphImpl graph, final QueryProcessor provider, final IntProcedure procedure, final boolean store) {

		provider.querySupport.ensureLoaded(graph, id);
		int single = provider.querySupport.getSingleSuperrelation(id);
		if(single > 0) {
			procedure.execute(graph, single);
			procedure.finished(graph);
			return single;
		}

		final int subrelationOf = provider.getSubrelationOf();

		final IntSet result = new IntSet(provider.querySupport);

		final class DirectProcedure extends Koss implements IntProcedure, TIntProcedure {
			@Override
			final public boolean execute(int r) {
				result.add(r);
				return true;
			}
			@Override
			final public void execute(ReadGraphImpl graph, int r) {
				if(single == 0) {
					single = r;
					return;
				}
				add(r);
			}
			@Override
			public void finished(ReadGraphImpl graph) {
			}
			@Override
			public void exception(ReadGraphImpl graph, Throwable t) {
				throw new Error("Errors are not supported.", t);
			}

		}

		final DirectProcedure directProc = new DirectProcedure();

		provider.querySupport.getObjects(graph, id, subrelationOf, directProc);

		int size = directProc.size();

		if(size == 0) {

			procedure.finished(graph);

		} else if (size == 1) {

			procedure.execute(graph, directProc.single);
			procedure.finished(graph);

		} else {

			directProc.forEach(new TIntProcedure() {

				@Override
				public boolean execute(int arg0) {

					procedure.execute(graph, arg0);
					return true;

				}

			});

			procedure.finished(graph);

		}
		
		return result;

	}

	@Override
	public String toString() {
		return "SuperRelations2[" + id + "]";
	}

	@Override
	public Object performFromCache(ReadGraphImpl graph, QueryProcessor provider, IntProcedure procedure) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void recompute(ReadGraphImpl graph, QueryProcessor provider) {

	}

}
