/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.impl.DebugPolicy;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;

final public class AsyncReadEntry<T> extends CacheEntryBase {

    protected AsyncRead<T> request;

    public AsyncReadEntry(AsyncRead<T> request) {
    	this.request = request;
    	if(DebugPolicy.QUERY_STATE) System.out.println("[QUERY STATE]: created " + this);
    }

    @Override
    int makeHash() {
    	return request.hashCode();
    }
    
    @Override
    public Object getOriginalRequest() {
        return request;
    }
    
    @Override
    public void discard() {
    	super.discard();
    	//request = null;
    	setResult(null);
    }
    
    final public void addOrSet(AsyncReadGraph graph, Object item) {

    	assert(isPending());
        
//        ArrayList<AsyncProcedure<T>> p = null;

        synchronized(this) {
        	
            setResult(item);
        	setReady();
//            p = procs;
//            procs = null;
            
        }

//        if(p != null)
//            for(AsyncProcedure<T> proc : p) {
//            	proc.execute(graph, (T)item);
////                proc.first.execute(graph, (T)item);
////                proc.second.dec();
//            }
        
    }
    
    
    public void except(AsyncReadGraph graph, Throwable t) {
    	
    	assert(isPending());
        
//        ArrayList<AsyncProcedure<T>> p = null;

        synchronized(this) {
        	
            except(t);
////            p = procs;
//            procs = null;
            
        }

//        if(p != null)
//            for(AsyncProcedure<T> proc : p) {
//            	proc.exception(graph, t);
//            }
    	
    }
    
    
    @Override
    final public Query getQuery() {
    	
        return new Query() {

			@Override
			public void recompute(ReadGraphImpl graph, Object provider, CacheEntry entry) {
				
				QueryProcessor qp = (QueryProcessor)provider;

				final ReadGraphImpl parentGraph = ReadGraphImpl.forRecompute(entry, qp); 

				try {

				    request.perform(parentGraph , new AsyncProcedure<T>() {

                        @Override
                        public void execute(AsyncReadGraph graph, T result) {
                            addOrSet(graph, result);
                        }
            			
            			@Override
            			public void exception(AsyncReadGraph graph, Throwable t) {
            			    except(t);
                        }

                    });

				} catch (Throwable t) {
				    except(t);
                }
				
			}

			@Override
			public void removeEntry(QueryProcessor qp) {
		    	qp.asyncReadMap.remove(request);
			}

			@Override
			public int type() {
				return request.getFlags();
			}
			
			@Override
			public String toString() {
				if(request == null) return "DISCARDED";
				else if(isExcepted()) return request.toString() + " " + getResult();
				else return request.toString() + " " + statusOrException;
			}
        	
        };
        
    }

	@SuppressWarnings("unchecked")
	public void performFromCache(ReadGraphImpl graph, Object provider, Object procedure) {
		
        AsyncProcedure<T> proc = (AsyncProcedure<T>)procedure;

	    if(isExcepted()) {
            
            try {
                proc.exception(graph, (Throwable)getResult());
            } catch (Throwable t) {
                t.printStackTrace();
            }
            
        } else {
            
            try {
                proc.execute(graph, (T)getResult());
            } catch (Throwable t) {
                t.printStackTrace();
            }
            
        }
		
	}

	@Override
	public String toString() {
		if(isDiscarded()) return "DISCARDED " + request.toString();
		else if(isExcepted()) return request.toString() + " " + getResult();
		else return request.toString() + " " + statusOrException;
	}

}
