/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.graph;

import java.util.Set;

import org.simantics.db.DirectStatements;
import org.simantics.db.RelationInfo;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.VirtualGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.AsyncSetListener;
import org.simantics.db.procedure.ListenerBase;
import org.simantics.db.procedure.MultiProcedure;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.StatementProcedure;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.MultiRead;
import org.simantics.db.request.Read;

public interface ReadGraphSupport {

    Session getSession();
    
    void forPossibleObject(ReadGraphImpl graph, Resource subject, Resource predicate, AsyncProcedure<Resource> procedure);
    
    void forEachPredicate(ReadGraphImpl graph, Resource subject, AsyncMultiProcedure<Resource> procedure);
    void forEachPredicate(ReadGraphImpl graph, Resource subject, MultiProcedure<Resource> procedure);
    IntSet getPredicates(ReadGraphImpl graph, Resource subject) throws Throwable;

    void forEachStatement(ReadGraphImpl graph, Resource subject, Resource predicate, MultiProcedure<Statement> procedure);
    void forEachStatement(ReadGraphImpl graph, Resource subject, Resource predicate, AsyncMultiProcedure<Statement> procedure);
    void forEachStatement(ReadGraphImpl graph, Resource subject, Resource predicate, StatementProcedure procedure);
    void forStatementSet(ReadGraphImpl graph, Resource subject, Resource predicate, AsyncSetListener<Statement> procedure);
    void forAssertedStatementSet(ReadGraphImpl graph, Resource subject, Resource predicate, AsyncSetListener<Statement> procedure);
    void forEachAssertedStatement(ReadGraphImpl graph, Resource subject, Resource predicate, AsyncMultiProcedure<Statement> procedure);
    void forEachObject(ReadGraphImpl graph, Resource subject, Resource predicate, MultiProcedure<Resource> procedure);
    void forEachObject(ReadGraphImpl graph, Resource subject, Resource predicate, AsyncMultiProcedure<Resource> procedure);
    void forEachDirectPredicate(ReadGraphImpl graph, Resource subject, AsyncMultiProcedure<Resource> procedure);
    void forEachDirectStatement(ReadGraphImpl graph, Resource subject, Procedure<DirectStatements> procedure);
    void forEachDirectStatement(ReadGraphImpl graph, Resource subject, AsyncProcedure<DirectStatements> procedure, boolean ignoreVirtual);
    void forObjectSet(ReadGraphImpl graph, Resource subject, Resource predicate, AsyncSetListener<Resource> procedure);
    void forPredicateSet(ReadGraphImpl graph, Resource subject, AsyncSetListener<Resource> procedure);
    void forPrincipalTypeSet(ReadGraphImpl graph, Resource subject, AsyncSetListener<Resource> procedure);
    void forEachAssertedObject(ReadGraphImpl graph, Resource subject, Resource predicate, AsyncMultiProcedure<Resource> procedure);
    void forAssertedObjectSet(ReadGraphImpl graph, Resource subject, Resource predicate, AsyncSetListener<Resource> procedure);
    void forEachPrincipalType(ReadGraphImpl graph, Resource subject, AsyncMultiProcedure<Resource> procedure);
    void forEachPrincipalType(ReadGraphImpl graph, Resource subject, MultiProcedure<Resource> procedure);

    void forRelationInfo(ReadGraphImpl graph, Resource subject, AsyncProcedure<RelationInfo> procedure);
    void forTypes(ReadGraphImpl graph, Resource subject, AsyncProcedure<Set<Resource>> procedure);
    IntSet getTypes(ReadGraphImpl graph, Resource subject) throws Throwable;
    void forSupertypes(ReadGraphImpl graph, Resource subject, AsyncProcedure<Set<Resource>> procedure);
    void forDirectSuperrelations(ReadGraphImpl graph, Resource subject, AsyncMultiProcedure<Resource> procedure);
    void forPossibleSuperrelation(ReadGraphImpl graph, Resource subject, AsyncProcedure<Resource> procedure);
    void forSuperrelations(ReadGraphImpl graph, Resource subject, AsyncProcedure<Set<Resource>> procedure);
    byte[] getValue(ReadGraphImpl graph, Resource subject) throws DatabaseException;
    byte[] forValue(ReadGraphImpl graph, Resource subject, AsyncProcedure<byte[]> procedure);
    void forPossibleValue(ReadGraphImpl graph, Resource subject, AsyncProcedure<byte[]> procedure);
    void forInverse(ReadGraphImpl graph, Resource relation, AsyncProcedure<Resource> procedure);
    void forResource(ReadGraphImpl graph, String id, AsyncProcedure<Resource> procedure);
    void forBuiltin(ReadGraphImpl graph, String id, AsyncProcedure<Resource> procedure);
    
    void forHasStatement(ReadGraphImpl graph, Resource subject, AsyncProcedure<Boolean> procedure);
    void forHasStatement(ReadGraphImpl graph, Resource subject, Resource predicate, AsyncProcedure<Boolean> procedure);
    void forHasStatement(ReadGraphImpl graph, Resource subject, Resource predicate, Resource object, AsyncProcedure<Boolean> procedure);

    void forHasValue(ReadGraphImpl graph, Resource subject, AsyncProcedure<Boolean> procedure);
    void forOrderedSet(ReadGraphImpl graph, Resource subject, AsyncMultiProcedure<Resource> procedure);

    <T> T queryRead(ReadGraphImpl graph, Read<T> request, CacheEntry parent, AsyncProcedure<T> procedure, ListenerBase listener) throws Throwable;
    <T> void query(ReadGraphImpl graph, MultiRead<T> request, CacheEntry parent, AsyncMultiProcedure<T> procedure, ListenerBase listener);
    <T> void query(ReadGraphImpl graph, AsyncRead<T> request, CacheEntry parent, AsyncProcedure<T> procedure, ListenerBase listener);
    <T> void query(ReadGraphImpl graph, AsyncMultiRead<T> request, CacheEntry parent, AsyncMultiProcedure<T> procedure, ListenerBase listener);
    <T> void query(ReadGraphImpl graph, ExternalRead<T> request, CacheEntry parent, Procedure<T> procedure, ListenerBase listener);
    
    <T> T tryQuery(final ReadGraphImpl graph, final Read<T> request) throws DatabaseException;
    <T> void tryQuery(final ReadGraphImpl graph, final AsyncRead<T> request, final AsyncProcedure<T> procedure);
    
    VirtualGraph getProvider(Resource subject, Resource predicate, Resource object);
    VirtualGraph getProvider(Resource subject, Resource predicate);
    VirtualGraph getValueProvider(Resource subject);
    
}
