package org.simantics.db.impl;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.RelationInfo;
import org.simantics.db.procedure.AsyncContextProcedure;

public final class ForPossibleRelatedValueContextProcedure<C, T> implements AsyncContextProcedure<C, T> {

	public final int predicateKey;
	public final int[] clusterKey;
	public final int[] predicateReference;
	public final RelationInfo info;
	public final ClusterI.CompleteTypeEnum completeType;
	private final AsyncContextProcedure<C, T> user;
	
	public ForPossibleRelatedValueContextProcedure(int predicateKey, RelationInfo info, AsyncContextProcedure<C, T> user) {
		this.predicateKey = predicateKey;
		this.completeType = ClusterTraitsBase.getCompleteTypeFromResourceKey(predicateKey); 
		this.info = info;
		this.user = user;
		this.clusterKey = new int[32*8];
		this.predicateReference = new int[32*8];
	}
	
	@Override
	public void execute(AsyncReadGraph graph, C context, T result) {
		user.execute(graph, context, result);
	}

	@Override
	public void exception(AsyncReadGraph graph, Throwable throwable) {
		user.exception(graph, throwable);
	}
	
};
