package org.simantics.db.impl;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.RelationInfo;
import org.simantics.db.Resource;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.procedure.AsyncMultiProcedure;

public final class ForEachObjectProcedure implements AsyncMultiProcedure<Resource> {

	public final int predicateKey;
	public final int[] clusterKey;
	public final int[] predicateReference;
	public final RelationInfo info;
	public final QueryProcessor processor;
	public final ClusterI.CompleteTypeEnum completeType;
	private final AsyncMultiProcedure<Resource> user;
	
	public ForEachObjectProcedure(int predicateKey, RelationInfo info, QueryProcessor processor, AsyncMultiProcedure<Resource> user) {
		this.predicateKey = predicateKey;
		this.completeType = ClusterTraitsBase.getCompleteTypeFromResourceKey(predicateKey); 
		this.info = info;
		this.user = user;
		this.processor = processor;
		this.clusterKey = new int[32*8];
		this.predicateReference = new int[32*8];
	}
	
	@Override
	public void execute(AsyncReadGraph graph, Resource result) {
		user.execute(graph, result);
	}

	@Override
	public void finished(AsyncReadGraph graph) {
		user.finished(graph);
	}

	@Override
	public void exception(AsyncReadGraph graph, Throwable throwable) {
		user.exception(graph, throwable);
	}
	
}
