package org.simantics.db.impl;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.RelationInfo;
import org.simantics.db.Resource;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.procedure.AsyncContextMultiProcedure;

public final class ForEachObjectContextProcedure<C> implements AsyncContextMultiProcedure<C, Resource> {

	public final int predicateKey;
	public final int[] clusterKey;
	public final int[] predicateReference;
	public final RelationInfo info;
	public final QueryProcessor processor;
	public final ClusterI.CompleteTypeEnum completeType;
	private final AsyncContextMultiProcedure<C, Resource> user;
	
	public ForEachObjectContextProcedure(int predicateKey, RelationInfo info, QueryProcessor processor, AsyncContextMultiProcedure<C, Resource> user) {
		this.predicateKey = predicateKey;
		this.completeType = ClusterTraitsBase.getCompleteTypeFromResourceKey(predicateKey); 
		this.info = info;
		this.user = user;
		this.processor = processor;
		this.clusterKey = new int[32*8];
		this.predicateReference = new int[32*8];
	}
	
	@Override
	public void execute(AsyncReadGraph graph, C context, Resource result) {
		user.execute(graph, context, result);
	}

	@Override
	public void finished(AsyncReadGraph graph, C context) {
		user.finished(graph, context);
	}

	@Override
	public void exception(AsyncReadGraph graph, Throwable throwable) {
		user.exception(graph, throwable);
	}
	
}
