/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import org.simantics.db.Resource;
import org.simantics.db.request.AsyncMultiRead;

public abstract class ResourceAsyncMultiRead<T> implements AsyncMultiRead<T> {

    final protected Resource resource;

    @Override
    public int hashCode() {
        return resource.hashCode();
    }
    
    @Override
    final public int threadHash() {
    	return resource.getThreadHash();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        ResourceAsyncMultiRead<?> r = (ResourceAsyncMultiRead<?>) object;
        return resource.equals(r.resource);
    }

    public ResourceAsyncMultiRead(Resource resource) {
        this.resource = resource;
    }

}
