package org.simantics.db.common.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.ReflectionUtils;
import org.simantics.scl.reflection.ValueNotFoundException;
import org.simantics.scl.runtime.function.FunctionImpl3;

/**
 * Adapts a resource to (SCL) value.
 * @author Hannu Niemist&ouml;
 */
public class AdaptValue extends ResourceRead<Object> {
    
    public AdaptValue(Resource resource) {
        super(resource);
    }

    private static final FunctionImpl3<ReadGraph,Resource,Object,Object> functionApplication = new FunctionImpl3<ReadGraph,Resource,Object,Object>() {

		@Override
		public Object apply(ReadGraph graph, Resource resource, Object context) {
			try {
				return Functions.exec(graph, resource, graph, resource, context);
			} catch (DatabaseException e) {
				throw new RuntimeDatabaseException(e);
			}
		}

	};
    
    @Override
    public Object perform(ReadGraph graph) throws DatabaseException {
        String uri = graph.getURI(resource);        
        try {
			if(Layer0.URIs.Functions_functionApplication.equals(uri)) return functionApplication;
            return ReflectionUtils.getValue(uri).getValue();
        } catch (ValueNotFoundException e) {
            throw new DatabaseException("Couldn't adapt the value " + uri, e);
        }
    }

}
