/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.primitiverequest;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;

final public class PossibleUniqueAdapter<T> implements AsyncRead<T> {

	final private Resource resource;
    final private Class<T> clazz;
    
    @Override
    public int hashCode() {
        return resource.hashCode() + 31 * clazz.hashCode();
    }
    
    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        PossibleUniqueAdapter<?> r = (PossibleUniqueAdapter<?>)object;
        return resource.equals(r.resource) && clazz.equals(r.clazz);
    }

    @Override
    public int threadHash() {
    	return hashCode();
    }

    @Override
    public int getFlags() {
        return 0;
    }
    
    public PossibleUniqueAdapter(Resource resource, Class<T> clazz) {
        this.resource = resource;
        this.clazz = clazz;
    }

    @Override
    public void perform(AsyncReadGraph graph, AsyncProcedure<T> procedure) {
        
        graph.forPossibleUniqueAdapted(resource, clazz, procedure);
        
    }

}
