/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common;

import org.simantics.db.Resource;

/**
 * 
 */
final public class NamedTypedResource implements Comparable<NamedTypedResource> {
	
    final String   name;
    final Resource resource;
    final Resource type;

    public NamedTypedResource(String name, Resource resource, Resource type) {
    	assert(name != null);
    	assert(resource != null);
    	assert(type != null);
        this.name = name;
        this.resource = resource;
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public Resource getResource() {
        return resource;
    }

    public Resource getType() {
        return type;
    }

    @Override
    public int compareTo(NamedTypedResource o) {
        return name.compareToIgnoreCase(o.name);
    }

    @Override
    public String toString() {
        return name;
    }

    @Override
    public int hashCode() {
        return resource.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        NamedTypedResource other = (NamedTypedResource) obj;
        return resource.equals(other.resource) && type.equals(other.type) && name.equals(other.name);
    }

}
