/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.util.binary;

import java.io.IOException;
import java.nio.ByteBuffer;

/**
 * @author Tuukka Lehtonen
 * @since 1.22.1 & 1.24.0
 */
public class NullBinaryWriteable implements BinaryWriteable {

    @Override
    public void writeFully(ByteBuffer src) throws IOException {
    }

    @Override
    public void writeFully(ByteBuffer src, int length) throws IOException {
    }

    @Override
    public void write(int b) throws IOException {
    }

    @Override
    public void write(byte[] b) throws IOException {
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
    }

    @Override
    public void writeByte(int v) throws IOException {
    }

    @Override
    public void writeShort(int v) throws IOException {
    }

    @Override
    public void writeChar(int v) throws IOException {
    }

    @Override
    public void writeInt(int v) throws IOException {
    }

    @Override
    public void writeLong(long v) throws IOException {
    }

    @Override
    public void writeFloat(float v) throws IOException {
    }

    @Override
    public void writeDouble(double v) throws IOException {
    }

    @Override
    public void writeBytes(String s) throws IOException {
    }

    @Override
    public void writeChars(String s) throws IOException {
    }

    @Override
    public void writeUTF(String s) throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

}
