/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.type;

import java.util.Set;

import org.simantics.databoard.util.IdentityPair;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.Range;

public class DoubleType extends NumberType {
		
    public DoubleType() {}
    public DoubleType(String unit) {
    	setUnit( unit );
    }
    public DoubleType(String unit, Range range) {
    	setUnit( unit );
    	setRange(range);
    }
    public DoubleType(String unit, String range) {
    	setUnit( unit );
    	setRange(range);
    }
    
    public double minValue() {
    	Range range = getRange();
    	if (range==null) return -Double.MAX_VALUE;
    	Limit l = range.getLower();
    	double value = l.getValue().doubleValue();
    	
    	// Won't work
    	if (l.isExclusive()) value+= Double.MIN_VALUE;
    	
    	return value;
    }
    
    public double maxValue() {
    	Range range = getRange();
    	if (range==null) return Double.MAX_VALUE;
    	Limit l = range.getUpper();
    	double value = l.getValue().doubleValue();
    	
    	// Won't work
    	if (l.isExclusive()) value-= Double.MIN_VALUE;
    	
    	return value;
    }
    
    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Datatype, Datatype>> compareHistory) {
		if (this==obj) return true;
		if ( !hasEqualMetadata(obj) ) return false;
		return obj instanceof DoubleType;
	}
	
	@Override
	public int hashCode() {
		return 0xabcff33 + metadataHashCode();
	}    

	@Override
	public void accept(Visitor1 v, Object obj) {
	    v.visit(this, obj);        
	}

	@Override
	public <T> T accept(Visitor<T> v) {
	    return v.visit(this);
	}
	
}
