/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.type;

import org.simantics.databoard.util.ObjectUtils;

public class Component {
	public String name;
    public Datatype type;    
    
    public Component(String name, Datatype type) {		
		this.name = name;
		this.type = type;
	}

	@Override
    public int hashCode() {
    	return type.hashCode() + 13*ObjectUtils.hashCode(name);
    }
    
    @Override
    public boolean equals(Object obj) {
		if (this==obj) return true;
		if (obj instanceof Component == false) return false;
		Component other = (Component) obj;
		return type.equals(other.type) && ObjectUtils.objectEquals(name, other.name);
    }

    @Override
    public String toString() {
    	return name + " = " + type;
    }
    
}

