package org.simantics.databoard.serialization.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.Serializer.NonRecursiveSerializer;

public class DoubleSerializer extends NonRecursiveSerializer {

	DoubleBinding binding;
	
	public DoubleSerializer(DoubleBinding binding) {this.binding = binding;}
	
	@Override
	public Object deserialize(DataInput in) throws IOException {
		try {
			double value = in.readDouble();
			return binding.create(value);
		} catch (BindingException e) {
			throw new IOException( e ); 
		}
	}
	
	@Override
	public void deserializeTo(DataInput in, Object obj) throws IOException {
		try {
			double value = in.readDouble();
			binding.setValue(obj, value);
		} catch (BindingException e) {
			throw new IOException( e ); 
		}
	}

	@Override
	public void skip(DataInput in)
			throws IOException {
		in.skipBytes(8);			
	}
	
	@Override
	public void serialize(DataOutput out, Object obj) throws IOException {
		try {
			double value = binding.getValue_(obj);
			out.writeDouble(value);
		} catch (BindingException e) {
			throw new IOException( e ); 
		}
	}

	@Override
	public Integer getConstantSize() {
		return 8;
	}

	@Override
	public int getSize(Object obj) {
		return 8;
	}
	
	@Override
	public int getMinSize() {
		return 8;
	}
	
	public double getDouble(DataInput in) throws IOException
	{
		return in.readDouble();
	}
	
	public void putDouble(DataOutput out, double x) throws IOException
	{
		out.writeDouble(x);
	}
	
}