/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.parser.ast.type;

import org.simantics.databoard.parser.ast.type.visitor.AstTypePrinter;
import org.simantics.databoard.parser.ast.type.visitor.AstTypeVisitor;
import org.simantics.databoard.parser.ast.type.visitor.AstTypeVisitorVoid;

public abstract class AstType {
	public abstract void accept(AstTypeVisitorVoid v);
	public abstract <T> T accept(AstTypeVisitor<T> v);
	
	@Override
	public String toString() {
		AstTypePrinter printer = new AstTypePrinter();
		accept(printer);
		return printer.toString();
	}
}
