package org.simantics.databoard.channel;

import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;

/**
 * Service exception is a problem in processing the service request.
 * It is produces by Service Handler. Service Exception is not a communication 
 * error.   
 *
 * @author Toni Kalajainen <toni.kalajainen@iki.fi>
 */
public abstract class ServiceException extends Exception {

	private static final long serialVersionUID = 1L;

	Variant error;
	
	public ServiceException(Variant error) {
		this.error = error;
	}
	
	public ServiceException(Binding binding, Object value) {
		error = new Variant(binding, value);
	}
	
	public Variant getError() {
		return error;
	}
	
	public Object getErrorType() {
		return error.type();
	}
	
	public Object getError(Binding binding) throws BindingException {
		try {
			return error.getValue(binding);
		} catch (AdaptException e) {
			if (e.getCause()!=null && e.getCause() instanceof BindingException) throw (BindingException) e.getCause();
			throw new BindingException(e);
		}
	}
	
}
