/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding;

import java.util.IdentityHashMap;
import java.util.Set;

import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.util.IdentityPair;

/**
 * This is a binding of Byte Type and a Java Object.
 * 
 * @see ByteType
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public abstract class ByteBinding extends NumberBinding {
	
	public ByteBinding(ByteType type) {
		this.type = type;
	}
	
	@Override
	public ByteType type() {
		return (ByteType) type;
	}
	
	public abstract Object create(byte value) throws BindingException;
	public abstract Object create(Byte value) throws BindingException;
	public abstract Object create(String value) throws BindingException;
	public abstract Object create(Number value) throws BindingException;
	public abstract Byte getValue(Object obj) throws BindingException;
	public abstract byte getValue_(Object obj) throws BindingException;
	public abstract void setValue(Object obj, Number value) throws BindingException;
	public abstract void setValue(Object obj, byte value) throws BindingException;
	public abstract boolean isInstance(Object obj);
	
    @Override
    public void accept(Visitor1 v, Object obj) {
        v.visit(this, obj);        
    }
    
    @Override
    public <T> T accept(Visitor<T> v) {
        return v.visit(this);
    }
    
	
    @Override
    public int deepCompare(Object o1, Object o2,
    		Set<IdentityPair<Object, Object>> compareHistory)
    		throws BindingException {
    	byte v1 = getValue_(o1);
    	byte v2 = getValue_(o2);
    	return (int)v1 - (int)v2;    	
    }
    
    @Override
    public int deepHashValue(Object value, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
    	byte v = getValue_(value);
    	return v;
    }
	
	public Object createUnchecked(byte value) throws RuntimeBindingException {
		try {
			return create(value);
		} catch (BindingException e) {
			return new RuntimeBindingException(e);
		}
	}
	public Object createUnchecked(Byte value) throws RuntimeBindingException {
		try {
			return create(value);
		} catch (BindingException e) {
			return new RuntimeBindingException(e);
		}
	}
	
    /*    
    @Override
    public void assertInstaceIsValid(Object obj)
    		throws BindingException {
    	if (!isInstance(obj)) throw new BindingException("Not a boolean instance");
    	ByteType type = getDataType();
    	Byte min = type.getMin();
    	Byte max = type.getMax();
    	if (min!=null || max!=null) {
    		Byte value = getValue(obj);
    		if (min!=null && value<min) throw new BindingException("The value is("+value+") below the minimum ("+min+")");
    		if (max!=null && value>max) throw new BindingException("The value is("+value+") over the maximum ("+max+")");
    	}
    }
*/    
}

