/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.interestset;

import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.type.VariantType;

/**
 * Interest set of Variant Type.
 *
 * @see VariantType
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class VariantInterestSet extends InterestSet {
	
	public static final VariantInterestSet MONITOR_EVERYTHING = new VariantInterestSet(true, true, null, true); 
	
	// Notification
	/** Interested in notification (excludes the value) */
	public boolean notification;
	
	// Value Assignment
	/** Interested in the value assignment (includes notification) */  
	public boolean value;
	
	// Component
	/** Component intersts, null if no specific interest */
	public @Optional InterestSet componentInterest;
	
	/** Interested in the complete structure of the container. Includes interest in value assignment and notification */
	public boolean completeComponent;
		
	/**
	 * Create a new interest set of a variant.
	 * 
	 * @param notification interest in notification of assignment
	 * @param value interest in notification and the new value of value assignment
	 * @param componentInterest specific interest in the value
	 * @param completeContainer interest in notification, the new value and complete sub structure of the container
	 */
	public VariantInterestSet(boolean notification, boolean value, InterestSet componentInterest, boolean completeContainer) {
		this.notification = notification;
		this.value = value;
		this.completeComponent = completeContainer;
		this.componentInterest = componentInterest;
	}

	/**
	 * Returns true, if interested in notification of value assignment.
	 * This doesn't include interest in the new value.
	 * 
	 * @return true, if interested in notification of value assignment.
	 */
	public boolean inNotifications() {
		return notification | value | completeComponent | (componentInterest!=null);
	}	
	
	/**
	 * Returns true, if interested in the value assignment  
	 * 
	 * @return true, if interested in the value assignment
	 */
	public boolean inValues() {
		return value | completeComponent | (componentInterest!=null);
	}
	
	/**
	 * Returns true, if interested in everything in the sub container, value assignment and change 
	 * 
	 * @return true, if has interest to the complete sub-tree of the component
	 */
	public boolean inCompleteComponent() {
		return completeComponent;
	}
	
	/**
	 * Component interest of expected type. If interest set doesn't match the type of
	 * the assigned value, then this field is ignored.
	 * 
	 * @return the interest of the component, or <code>null</code>
	 */
	public InterestSet getComponentInterest() {
		return componentInterest;
	}
	
}

