/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.file;

import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.ArrayAccessor.CloseableArrayAccessor;
import org.simantics.databoard.accessor.CloseableAccessor;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;

public interface FileArrayAccessor extends ArrayAccessor, FileAccessor, CloseableAccessor, CloseableArrayAccessor {

	/**
	 * Add a new value. 
	 * 
	 * @param binding
	 * @param value value
	 * @throws AccessorException
	 */
	void addNoflush(Binding binding, Object value) throws AccessorException;

	/**
	 * Add an array of elements.
	 * 
	 * @param binding
	 * @param values value 
	 * @throws AccessorException
	 */
	void addAllNoflush(Binding binding, Object[] values) throws AccessorException;
	
	/**
	 * Add an array of elements.  
	 * 
	 * If elements are inserted in the middle of the array, existing interest sets
	 * are updated to reflect the new positions. 
	 * 
	 * @param index position to insert new value to
	 * @param binding
	 * @param values
	 * @throws AccessorException
	 */
	void addAllNoflush(int index, Binding binding, Object[] values) throws AccessorException;
	
	/**
	 * Insert a new value.
	 * 
	 * If elements are inserted in the middle of the array, existing interest sets
	 * are updated to reflect the new positions. 
	 * 
	 * @param index position to insert new value to
	 * @param binding
	 * @param value value
	 * @throws AccessorException
	 */
	void addNoflush(int index, Binding binding, Object value) throws AccessorException;
	
	/**
	 * Set all elements from an Array Value.
	 * 
	 * If array becomes shorter and there are accessors to the removed elements,
	 * the accessors are invalidated. 
	 * 
	 * @param binding
	 * @param newValue
	 * @throws BindingException binding error
	 * @throws UnsupportedOperationException cannot set a new value
	 */
	void setValueNoflush(Binding binding, Object newValue) throws AccessorException;
	
	/**
	 * Replace a value container with a new value.
	 * 
	 * @param index
	 * @param binding
	 * @param value
	 * @throws AccessorException
	 */
	void setNoflush(int index, Binding binding, Object value) throws AccessorException;
	
	/**
	 * Remove an element at an index.
	 *  
	 * If there are listeners to elements after the <code>null</code>, the 
	 * interest sets and accessor paths are updated and decreased.    
	 * 
	 * If there was an accessor, it becomes invalid.
	 * 
	 * @param index
	 * @param count
	 * @throws AccessorException
	 */
	void removeNoflush(int index, int count) throws AccessorException;
	
	/**
	 * Set new array size
	 * 
	 * @param newSize
	 * @throws AccessorException
	 */
	void setSizeNoflush(int newSize) throws AccessorException;	
	
}

