/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.compressions.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

import org.simantics.compressions.CompressionCodec;

/**
 * @author Tuukka Lehtonen
 */
public class DecompressingCodecInputStream extends DecompressingInputStream {

    protected CompressionCodec codec;

    public DecompressingCodecInputStream(CompressionCodec codec, File file) throws FileNotFoundException {
        this(codec, new FileInputStream(file));
    }

    public DecompressingCodecInputStream(CompressionCodec codec, FileInputStream stream) {
        this(codec, stream, stream.getChannel());
    }

    public DecompressingCodecInputStream(CompressionCodec codec, InputStream stream, ReadableByteChannel channel) {
        super(stream, channel);
        this.codec = codec;
    }

    public void decompress(ByteBuffer compressed, int compressedOffset, int compressedSize,
            ByteBuffer uncompressed, int uncompressedOffset, int uncompressedSize) throws IOException {
        codec.decompressBuffer(compressed, compressedOffset, compressedSize, uncompressed, uncompressedOffset, uncompressedSize);
    }

}